/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.FactoryRepoConfiguration;
import java.io.IOException;

public final class FactoryVstsConfiguration
extends FactoryRepoConfiguration {
    private String type = "FactoryVSTSConfiguration";
    private String projectName;
    private String tenantId;
    private static final ClientLogger LOGGER = new ClientLogger(FactoryVstsConfiguration.class);

    @Override
    public String type() {
        return this.type;
    }

    public String projectName() {
        return this.projectName;
    }

    public FactoryVstsConfiguration withProjectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public FactoryVstsConfiguration withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public FactoryVstsConfiguration withAccountName(String accountName) {
        super.withAccountName(accountName);
        return this;
    }

    @Override
    public FactoryVstsConfiguration withRepositoryName(String repositoryName) {
        super.withRepositoryName(repositoryName);
        return this;
    }

    @Override
    public FactoryVstsConfiguration withCollaborationBranch(String collaborationBranch) {
        super.withCollaborationBranch(collaborationBranch);
        return this;
    }

    @Override
    public FactoryVstsConfiguration withRootFolder(String rootFolder) {
        super.withRootFolder(rootFolder);
        return this;
    }

    @Override
    public FactoryVstsConfiguration withLastCommitId(String lastCommitId) {
        super.withLastCommitId(lastCommitId);
        return this;
    }

    @Override
    public FactoryVstsConfiguration withDisablePublish(Boolean disablePublish) {
        super.withDisablePublish(disablePublish);
        return this;
    }

    @Override
    public void validate() {
        if (this.projectName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property projectName in model FactoryVstsConfiguration"));
        }
        if (this.accountName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property accountName in model FactoryVstsConfiguration"));
        }
        if (this.repositoryName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property repositoryName in model FactoryVstsConfiguration"));
        }
        if (this.collaborationBranch() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property collaborationBranch in model FactoryVstsConfiguration"));
        }
        if (this.rootFolder() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property rootFolder in model FactoryVstsConfiguration"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("accountName", this.accountName());
        jsonWriter.writeStringField("repositoryName", this.repositoryName());
        jsonWriter.writeStringField("collaborationBranch", this.collaborationBranch());
        jsonWriter.writeStringField("rootFolder", this.rootFolder());
        jsonWriter.writeStringField("lastCommitId", this.lastCommitId());
        jsonWriter.writeBooleanField("disablePublish", this.disablePublish());
        jsonWriter.writeStringField("projectName", this.projectName);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("tenantId", this.tenantId);
        return jsonWriter.writeEndObject();
    }

    public static FactoryVstsConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (FactoryVstsConfiguration)jsonReader.readObject(reader -> {
            FactoryVstsConfiguration deserializedFactoryVstsConfiguration = new FactoryVstsConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accountName".equals(fieldName)) {
                    deserializedFactoryVstsConfiguration.withAccountName(reader.getString());
                    continue;
                }
                if ("repositoryName".equals(fieldName)) {
                    deserializedFactoryVstsConfiguration.withRepositoryName(reader.getString());
                    continue;
                }
                if ("collaborationBranch".equals(fieldName)) {
                    deserializedFactoryVstsConfiguration.withCollaborationBranch(reader.getString());
                    continue;
                }
                if ("rootFolder".equals(fieldName)) {
                    deserializedFactoryVstsConfiguration.withRootFolder(reader.getString());
                    continue;
                }
                if ("lastCommitId".equals(fieldName)) {
                    deserializedFactoryVstsConfiguration.withLastCommitId(reader.getString());
                    continue;
                }
                if ("disablePublish".equals(fieldName)) {
                    deserializedFactoryVstsConfiguration.withDisablePublish((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("projectName".equals(fieldName)) {
                    deserializedFactoryVstsConfiguration.projectName = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFactoryVstsConfiguration.type = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedFactoryVstsConfiguration.tenantId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFactoryVstsConfiguration;
        });
    }
}

