/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.FactoryUpdateProperties;
import com.azure.resourcemanager.datafactory.models.FactoryIdentity;
import com.azure.resourcemanager.datafactory.models.PublicNetworkAccess;
import java.io.IOException;
import java.util.Map;

public final class FactoryUpdateParameters
implements JsonSerializable<FactoryUpdateParameters> {
    private Map<String, String> tags;
    private FactoryIdentity identity;
    private FactoryUpdateProperties innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public FactoryUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public FactoryIdentity identity() {
        return this.identity;
    }

    public FactoryUpdateParameters withIdentity(FactoryIdentity identity) {
        this.identity = identity;
        return this;
    }

    private FactoryUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public FactoryUpdateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FactoryUpdateProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static FactoryUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (FactoryUpdateParameters)jsonReader.readObject(reader -> {
            FactoryUpdateParameters deserializedFactoryUpdateParameters = new FactoryUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedFactoryUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedFactoryUpdateParameters.identity = FactoryIdentity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedFactoryUpdateParameters.innerProperties = FactoryUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFactoryUpdateParameters;
        });
    }
}

