/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.FactoryRepoConfiguration;
import java.io.IOException;

public final class FactoryRepoUpdate
implements JsonSerializable<FactoryRepoUpdate> {
    private String factoryResourceId;
    private FactoryRepoConfiguration repoConfiguration;

    public String factoryResourceId() {
        return this.factoryResourceId;
    }

    public FactoryRepoUpdate withFactoryResourceId(String factoryResourceId) {
        this.factoryResourceId = factoryResourceId;
        return this;
    }

    public FactoryRepoConfiguration repoConfiguration() {
        return this.repoConfiguration;
    }

    public FactoryRepoUpdate withRepoConfiguration(FactoryRepoConfiguration repoConfiguration) {
        this.repoConfiguration = repoConfiguration;
        return this;
    }

    public void validate() {
        if (this.repoConfiguration() != null) {
            this.repoConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("factoryResourceId", this.factoryResourceId);
        jsonWriter.writeJsonField("repoConfiguration", (JsonSerializable)this.repoConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static FactoryRepoUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (FactoryRepoUpdate)jsonReader.readObject(reader -> {
            FactoryRepoUpdate deserializedFactoryRepoUpdate = new FactoryRepoUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("factoryResourceId".equals(fieldName)) {
                    deserializedFactoryRepoUpdate.factoryResourceId = reader.getString();
                    continue;
                }
                if ("repoConfiguration".equals(fieldName)) {
                    deserializedFactoryRepoUpdate.repoConfiguration = FactoryRepoConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFactoryRepoUpdate;
        });
    }
}

