/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.FactoryInner;
import java.io.IOException;
import java.util.List;

public final class FactoryListResponse
implements JsonSerializable<FactoryListResponse> {
    private List<FactoryInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(FactoryListResponse.class);

    public List<FactoryInner> value() {
        return this.value;
    }

    public FactoryListResponse withValue(List<FactoryInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public FactoryListResponse withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model FactoryListResponse"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static FactoryListResponse fromJson(JsonReader jsonReader) throws IOException {
        return (FactoryListResponse)jsonReader.readObject(reader -> {
            FactoryListResponse deserializedFactoryListResponse = new FactoryListResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedFactoryListResponse.value = value = reader.readArray(reader1 -> FactoryInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedFactoryListResponse.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFactoryListResponse;
        });
    }
}

