/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.Activity;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.AzureDataExplorerCommandActivity;
import com.azure.resourcemanager.datafactory.models.AzureFunctionActivity;
import com.azure.resourcemanager.datafactory.models.AzureMLBatchExecutionActivity;
import com.azure.resourcemanager.datafactory.models.AzureMLExecutePipelineActivity;
import com.azure.resourcemanager.datafactory.models.AzureMLUpdateResourceActivity;
import com.azure.resourcemanager.datafactory.models.CopyActivity;
import com.azure.resourcemanager.datafactory.models.CustomActivity;
import com.azure.resourcemanager.datafactory.models.DataLakeAnalyticsUsqlActivity;
import com.azure.resourcemanager.datafactory.models.DatabricksNotebookActivity;
import com.azure.resourcemanager.datafactory.models.DatabricksSparkJarActivity;
import com.azure.resourcemanager.datafactory.models.DatabricksSparkPythonActivity;
import com.azure.resourcemanager.datafactory.models.DeleteActivity;
import com.azure.resourcemanager.datafactory.models.ExecuteDataFlowActivity;
import com.azure.resourcemanager.datafactory.models.ExecuteSsisPackageActivity;
import com.azure.resourcemanager.datafactory.models.GetMetadataActivity;
import com.azure.resourcemanager.datafactory.models.HDInsightHiveActivity;
import com.azure.resourcemanager.datafactory.models.HDInsightMapReduceActivity;
import com.azure.resourcemanager.datafactory.models.HDInsightPigActivity;
import com.azure.resourcemanager.datafactory.models.HDInsightSparkActivity;
import com.azure.resourcemanager.datafactory.models.HDInsightStreamingActivity;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.LookupActivity;
import com.azure.resourcemanager.datafactory.models.ScriptActivity;
import com.azure.resourcemanager.datafactory.models.SqlServerStoredProcedureActivity;
import com.azure.resourcemanager.datafactory.models.SynapseNotebookActivity;
import com.azure.resourcemanager.datafactory.models.SynapseSparkJobDefinitionActivity;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import com.azure.resourcemanager.datafactory.models.WebActivity;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExecutionActivity
extends Activity {
    private String type = "Execution";
    private LinkedServiceReference linkedServiceName;
    private ActivityPolicy policy;
    private static final ClientLogger LOGGER = new ClientLogger(ExecutionActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    public LinkedServiceReference linkedServiceName() {
        return this.linkedServiceName;
    }

    public ExecutionActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        this.linkedServiceName = linkedServiceName;
        return this;
    }

    public ActivityPolicy policy() {
        return this.policy;
    }

    public ExecutionActivity withPolicy(ActivityPolicy policy) {
        this.policy = policy;
        return this;
    }

    @Override
    public ExecutionActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ExecutionActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ExecutionActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public ExecutionActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public ExecutionActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn(dependsOn);
        return this;
    }

    @Override
    public ExecutionActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties(userProperties);
        return this;
    }

    @Override
    public void validate() {
        if (this.linkedServiceName() != null) {
            this.linkedServiceName().validate();
        }
        if (this.policy() != null) {
            this.policy().validate();
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ExecutionActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName);
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ExecutionActivity fromJson(JsonReader jsonReader) throws IOException {
        return (ExecutionActivity)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ExecutionActivity executionActivity;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Copy".equals(discriminatorValue)) {
                    executionActivity = CopyActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("HDInsightHive".equals(discriminatorValue)) {
                    executionActivity = HDInsightHiveActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("HDInsightPig".equals(discriminatorValue)) {
                    executionActivity = HDInsightPigActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("HDInsightMapReduce".equals(discriminatorValue)) {
                    executionActivity = HDInsightMapReduceActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("HDInsightStreaming".equals(discriminatorValue)) {
                    executionActivity = HDInsightStreamingActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("HDInsightSpark".equals(discriminatorValue)) {
                    executionActivity = HDInsightSparkActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("ExecuteSSISPackage".equals(discriminatorValue)) {
                    executionActivity = ExecuteSsisPackageActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("Custom".equals(discriminatorValue)) {
                    executionActivity = CustomActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("SqlServerStoredProcedure".equals(discriminatorValue)) {
                    executionActivity = SqlServerStoredProcedureActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("Delete".equals(discriminatorValue)) {
                    executionActivity = DeleteActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("AzureDataExplorerCommand".equals(discriminatorValue)) {
                    executionActivity = AzureDataExplorerCommandActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("Lookup".equals(discriminatorValue)) {
                    executionActivity = LookupActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("WebActivity".equals(discriminatorValue)) {
                    executionActivity = WebActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("GetMetadata".equals(discriminatorValue)) {
                    executionActivity = GetMetadataActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("AzureMLBatchExecution".equals(discriminatorValue)) {
                    executionActivity = AzureMLBatchExecutionActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("AzureMLUpdateResource".equals(discriminatorValue)) {
                    executionActivity = AzureMLUpdateResourceActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("AzureMLExecutePipeline".equals(discriminatorValue)) {
                    executionActivity = AzureMLExecutePipelineActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("DataLakeAnalyticsU-SQL".equals(discriminatorValue)) {
                    executionActivity = DataLakeAnalyticsUsqlActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("DatabricksNotebook".equals(discriminatorValue)) {
                    executionActivity = DatabricksNotebookActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("DatabricksSparkJar".equals(discriminatorValue)) {
                    executionActivity = DatabricksSparkJarActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("DatabricksSparkPython".equals(discriminatorValue)) {
                    executionActivity = DatabricksSparkPythonActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("AzureFunctionActivity".equals(discriminatorValue)) {
                    executionActivity = AzureFunctionActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("ExecuteDataFlow".equals(discriminatorValue)) {
                    executionActivity = ExecuteDataFlowActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("Script".equals(discriminatorValue)) {
                    executionActivity = ScriptActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("SynapseNotebook".equals(discriminatorValue)) {
                    executionActivity = SynapseNotebookActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("SparkJob".equals(discriminatorValue)) {
                    executionActivity = SynapseSparkJobDefinitionActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                executionActivity = ExecutionActivity.fromJsonKnownDiscriminator(readerToUse.reset());
                return executionActivity;
            }
        });
    }

    static ExecutionActivity fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ExecutionActivity)jsonReader.readObject(reader -> {
            ExecutionActivity deserializedExecutionActivity = new ExecutionActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedExecutionActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedExecutionActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedExecutionActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedExecutionActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedExecutionActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedExecutionActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExecutionActivity.type = reader.getString();
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedExecutionActivity.linkedServiceName = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedExecutionActivity.policy = ActivityPolicy.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedExecutionActivity.withAdditionalProperties(additionalProperties);
            return deserializedExecutionActivity;
        });
    }
}

