/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DistcpSettings
implements JsonSerializable<DistcpSettings> {
    private Object resourceManagerEndpoint;
    private Object tempScriptPath;
    private Object distcpOptions;
    private static final ClientLogger LOGGER = new ClientLogger(DistcpSettings.class);

    public Object resourceManagerEndpoint() {
        return this.resourceManagerEndpoint;
    }

    public DistcpSettings withResourceManagerEndpoint(Object resourceManagerEndpoint) {
        this.resourceManagerEndpoint = resourceManagerEndpoint;
        return this;
    }

    public Object tempScriptPath() {
        return this.tempScriptPath;
    }

    public DistcpSettings withTempScriptPath(Object tempScriptPath) {
        this.tempScriptPath = tempScriptPath;
        return this;
    }

    public Object distcpOptions() {
        return this.distcpOptions;
    }

    public DistcpSettings withDistcpOptions(Object distcpOptions) {
        this.distcpOptions = distcpOptions;
        return this;
    }

    public void validate() {
        if (this.resourceManagerEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceManagerEndpoint in model DistcpSettings"));
        }
        if (this.tempScriptPath() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property tempScriptPath in model DistcpSettings"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("resourceManagerEndpoint", this.resourceManagerEndpoint);
        jsonWriter.writeUntypedField("tempScriptPath", this.tempScriptPath);
        if (this.distcpOptions != null) {
            jsonWriter.writeUntypedField("distcpOptions", this.distcpOptions);
        }
        return jsonWriter.writeEndObject();
    }

    public static DistcpSettings fromJson(JsonReader jsonReader) throws IOException {
        return (DistcpSettings)jsonReader.readObject(reader -> {
            DistcpSettings deserializedDistcpSettings = new DistcpSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceManagerEndpoint".equals(fieldName)) {
                    deserializedDistcpSettings.resourceManagerEndpoint = reader.readUntyped();
                    continue;
                }
                if ("tempScriptPath".equals(fieldName)) {
                    deserializedDistcpSettings.tempScriptPath = reader.readUntyped();
                    continue;
                }
                if ("distcpOptions".equals(fieldName)) {
                    deserializedDistcpSettings.distcpOptions = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDistcpSettings;
        });
    }
}

