/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.Dataset;
import com.azure.resourcemanager.datafactory.models.SubResourceDebugResource;
import java.io.IOException;

public final class DatasetDebugResource
extends SubResourceDebugResource {
    private Dataset properties;
    private static final ClientLogger LOGGER = new ClientLogger(DatasetDebugResource.class);

    public Dataset properties() {
        return this.properties;
    }

    public DatasetDebugResource withProperties(Dataset properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public DatasetDebugResource withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model DatasetDebugResource"));
        }
        this.properties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static DatasetDebugResource fromJson(JsonReader jsonReader) throws IOException {
        return (DatasetDebugResource)jsonReader.readObject(reader -> {
            DatasetDebugResource deserializedDatasetDebugResource = new DatasetDebugResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDatasetDebugResource.withName(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDatasetDebugResource.properties = Dataset.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatasetDebugResource;
        });
    }
}

