/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DataFlowReferenceType;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class DataFlowReference
implements JsonSerializable<DataFlowReference> {
    private DataFlowReferenceType type;
    private String referenceName;
    private Object datasetParameters;
    private Map<String, Object> parameters;
    private Map<String, Object> additionalProperties;
    private static final ClientLogger LOGGER = new ClientLogger(DataFlowReference.class);

    public DataFlowReferenceType type() {
        return this.type;
    }

    public DataFlowReference withType(DataFlowReferenceType type) {
        this.type = type;
        return this;
    }

    public String referenceName() {
        return this.referenceName;
    }

    public DataFlowReference withReferenceName(String referenceName) {
        this.referenceName = referenceName;
        return this;
    }

    public Object datasetParameters() {
        return this.datasetParameters;
    }

    public DataFlowReference withDatasetParameters(Object datasetParameters) {
        this.datasetParameters = datasetParameters;
        return this;
    }

    public Map<String, Object> parameters() {
        return this.parameters;
    }

    public DataFlowReference withParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public DataFlowReference withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model DataFlowReference"));
        }
        if (this.referenceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property referenceName in model DataFlowReference"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("referenceName", this.referenceName);
        if (this.datasetParameters != null) {
            jsonWriter.writeUntypedField("datasetParameters", this.datasetParameters);
        }
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeUntyped(element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DataFlowReference fromJson(JsonReader jsonReader) throws IOException {
        return (DataFlowReference)jsonReader.readObject(reader -> {
            DataFlowReference deserializedDataFlowReference = new DataFlowReference();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedDataFlowReference.type = DataFlowReferenceType.fromString(reader.getString());
                    continue;
                }
                if ("referenceName".equals(fieldName)) {
                    deserializedDataFlowReference.referenceName = reader.getString();
                    continue;
                }
                if ("datasetParameters".equals(fieldName)) {
                    deserializedDataFlowReference.datasetParameters = reader.readUntyped();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedDataFlowReference.parameters = parameters = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDataFlowReference.additionalProperties = additionalProperties;
            return deserializedDataFlowReference;
        });
    }
}

