/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DataFlowFolder;
import com.azure.resourcemanager.datafactory.models.Flowlet;
import com.azure.resourcemanager.datafactory.models.MappingDataFlow;
import com.azure.resourcemanager.datafactory.models.WranglingDataFlow;
import java.io.IOException;
import java.util.List;

public class DataFlow
implements JsonSerializable<DataFlow> {
    private String type = "DataFlow";
    private String description;
    private List<Object> annotations;
    private DataFlowFolder folder;

    public String type() {
        return this.type;
    }

    public String description() {
        return this.description;
    }

    public DataFlow withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<Object> annotations() {
        return this.annotations;
    }

    public DataFlow withAnnotations(List<Object> annotations) {
        this.annotations = annotations;
        return this;
    }

    public DataFlowFolder folder() {
        return this.folder;
    }

    public DataFlow withFolder(DataFlowFolder folder) {
        this.folder = folder;
        return this;
    }

    public void validate() {
        if (this.folder() != null) {
            this.folder().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("annotations", this.annotations, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder);
        return jsonWriter.writeEndObject();
    }

    public static DataFlow fromJson(JsonReader jsonReader) throws IOException {
        return (DataFlow)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                DataFlow dataFlow;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("MappingDataFlow".equals(discriminatorValue)) {
                    dataFlow = MappingDataFlow.fromJson(readerToUse.reset());
                    return dataFlow;
                }
                if ("Flowlet".equals(discriminatorValue)) {
                    dataFlow = Flowlet.fromJson(readerToUse.reset());
                    return dataFlow;
                }
                if ("WranglingDataFlow".equals(discriminatorValue)) {
                    dataFlow = WranglingDataFlow.fromJson(readerToUse.reset());
                    return dataFlow;
                }
                dataFlow = DataFlow.fromJsonKnownDiscriminator(readerToUse.reset());
                return dataFlow;
            }
        });
    }

    static DataFlow fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (DataFlow)jsonReader.readObject(reader -> {
            DataFlow deserializedDataFlow = new DataFlow();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedDataFlow.type = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDataFlow.description = reader.getString();
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations;
                    deserializedDataFlow.annotations = annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedDataFlow.folder = DataFlowFolder.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataFlow;
        });
    }
}

