/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.CustomEventsTriggerTypeProperties;
import com.azure.resourcemanager.datafactory.models.MultiplePipelineTrigger;
import com.azure.resourcemanager.datafactory.models.TriggerPipelineReference;
import com.azure.resourcemanager.datafactory.models.TriggerRuntimeState;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class CustomEventsTrigger
extends MultiplePipelineTrigger {
    private String type = "CustomEventsTrigger";
    private CustomEventsTriggerTypeProperties innerTypeProperties = new CustomEventsTriggerTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(CustomEventsTrigger.class);

    @Override
    public String type() {
        return this.type;
    }

    CustomEventsTriggerTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public CustomEventsTrigger withPipelines(List<TriggerPipelineReference> pipelines) {
        super.withPipelines(pipelines);
        return this;
    }

    @Override
    public CustomEventsTrigger withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public CustomEventsTrigger withAnnotations(List<Object> annotations) {
        super.withAnnotations((List)annotations);
        return this;
    }

    public String subjectBeginsWith() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().subjectBeginsWith();
    }

    public CustomEventsTrigger withSubjectBeginsWith(String subjectBeginsWith) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CustomEventsTriggerTypeProperties();
        }
        this.innerTypeProperties().withSubjectBeginsWith(subjectBeginsWith);
        return this;
    }

    public String subjectEndsWith() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().subjectEndsWith();
    }

    public CustomEventsTrigger withSubjectEndsWith(String subjectEndsWith) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CustomEventsTriggerTypeProperties();
        }
        this.innerTypeProperties().withSubjectEndsWith(subjectEndsWith);
        return this;
    }

    public List<Object> events() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().events();
    }

    public CustomEventsTrigger withEvents(List<Object> events) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CustomEventsTriggerTypeProperties();
        }
        this.innerTypeProperties().withEvents(events);
        return this;
    }

    public String scope() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().scope();
    }

    public CustomEventsTrigger withScope(String scope) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CustomEventsTriggerTypeProperties();
        }
        this.innerTypeProperties().withScope(scope);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model CustomEventsTrigger"));
        }
        this.innerTypeProperties().validate();
        if (this.pipelines() != null) {
            this.pipelines().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeArrayField("pipelines", this.pipelines(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CustomEventsTrigger fromJson(JsonReader jsonReader) throws IOException {
        return (CustomEventsTrigger)jsonReader.readObject(reader -> {
            CustomEventsTrigger deserializedCustomEventsTrigger = new CustomEventsTrigger();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedCustomEventsTrigger.withDescription(reader.getString());
                    continue;
                }
                if ("runtimeState".equals(fieldName)) {
                    deserializedCustomEventsTrigger.withRuntimeState(TriggerRuntimeState.fromString(reader.getString()));
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedCustomEventsTrigger.withAnnotations(annotations);
                    continue;
                }
                if ("pipelines".equals(fieldName)) {
                    List pipelines = reader.readArray(reader1 -> TriggerPipelineReference.fromJson(reader1));
                    deserializedCustomEventsTrigger.withPipelines(pipelines);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedCustomEventsTrigger.innerTypeProperties = CustomEventsTriggerTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCustomEventsTrigger.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedCustomEventsTrigger.withAdditionalProperties(additionalProperties);
            return deserializedCustomEventsTrigger;
        });
    }
}

