/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeDebugResource;
import java.io.IOException;

public final class CreateDataFlowDebugSessionRequest
implements JsonSerializable<CreateDataFlowDebugSessionRequest> {
    private String computeType;
    private Integer coreCount;
    private Integer timeToLive;
    private IntegrationRuntimeDebugResource integrationRuntime;

    public String computeType() {
        return this.computeType;
    }

    public CreateDataFlowDebugSessionRequest withComputeType(String computeType) {
        this.computeType = computeType;
        return this;
    }

    public Integer coreCount() {
        return this.coreCount;
    }

    public CreateDataFlowDebugSessionRequest withCoreCount(Integer coreCount) {
        this.coreCount = coreCount;
        return this;
    }

    public Integer timeToLive() {
        return this.timeToLive;
    }

    public CreateDataFlowDebugSessionRequest withTimeToLive(Integer timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    public IntegrationRuntimeDebugResource integrationRuntime() {
        return this.integrationRuntime;
    }

    public CreateDataFlowDebugSessionRequest withIntegrationRuntime(IntegrationRuntimeDebugResource integrationRuntime) {
        this.integrationRuntime = integrationRuntime;
        return this;
    }

    public void validate() {
        if (this.integrationRuntime() != null) {
            this.integrationRuntime().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("computeType", this.computeType);
        jsonWriter.writeNumberField("coreCount", (Number)this.coreCount);
        jsonWriter.writeNumberField("timeToLive", (Number)this.timeToLive);
        jsonWriter.writeJsonField("integrationRuntime", (JsonSerializable)this.integrationRuntime);
        return jsonWriter.writeEndObject();
    }

    public static CreateDataFlowDebugSessionRequest fromJson(JsonReader jsonReader) throws IOException {
        return (CreateDataFlowDebugSessionRequest)jsonReader.readObject(reader -> {
            CreateDataFlowDebugSessionRequest deserializedCreateDataFlowDebugSessionRequest = new CreateDataFlowDebugSessionRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("computeType".equals(fieldName)) {
                    deserializedCreateDataFlowDebugSessionRequest.computeType = reader.getString();
                    continue;
                }
                if ("coreCount".equals(fieldName)) {
                    deserializedCreateDataFlowDebugSessionRequest.coreCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("timeToLive".equals(fieldName)) {
                    deserializedCreateDataFlowDebugSessionRequest.timeToLive = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("integrationRuntime".equals(fieldName)) {
                    deserializedCreateDataFlowDebugSessionRequest.integrationRuntime = IntegrationRuntimeDebugResource.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCreateDataFlowDebugSessionRequest;
        });
    }
}

