/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.LicensedComponentSetupTypeProperties;
import com.azure.resourcemanager.datafactory.models.CustomSetupBase;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class ComponentSetup
extends CustomSetupBase {
    private String type = "ComponentSetup";
    private LicensedComponentSetupTypeProperties innerTypeProperties = new LicensedComponentSetupTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(ComponentSetup.class);

    @Override
    public String type() {
        return this.type;
    }

    LicensedComponentSetupTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    public String componentName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().componentName();
    }

    public ComponentSetup withComponentName(String componentName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new LicensedComponentSetupTypeProperties();
        }
        this.innerTypeProperties().withComponentName(componentName);
        return this;
    }

    public SecretBase licenseKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().licenseKey();
    }

    public ComponentSetup withLicenseKey(SecretBase licenseKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new LicensedComponentSetupTypeProperties();
        }
        this.innerTypeProperties().withLicenseKey(licenseKey);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model ComponentSetup"));
        }
        this.innerTypeProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static ComponentSetup fromJson(JsonReader jsonReader) throws IOException {
        return (ComponentSetup)jsonReader.readObject(reader -> {
            ComponentSetup deserializedComponentSetup = new ComponentSetup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("typeProperties".equals(fieldName)) {
                    deserializedComponentSetup.innerTypeProperties = LicensedComponentSetupTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedComponentSetup.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedComponentSetup;
        });
    }
}

