/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySink;
import com.azure.resourcemanager.datafactory.models.SqlUpsertSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AzureSqlSink
extends CopySink {
    private String type = "AzureSqlSink";
    private Object sqlWriterStoredProcedureName;
    private Object sqlWriterTableType;
    private Object preCopyScript;
    private Object storedProcedureParameters;
    private Object storedProcedureTableTypeParameterName;
    private Object tableOption;
    private Object sqlWriterUseTableLock;
    private Object writeBehavior;
    private SqlUpsertSettings upsertSettings;

    @Override
    public String type() {
        return this.type;
    }

    public Object sqlWriterStoredProcedureName() {
        return this.sqlWriterStoredProcedureName;
    }

    public AzureSqlSink withSqlWriterStoredProcedureName(Object sqlWriterStoredProcedureName) {
        this.sqlWriterStoredProcedureName = sqlWriterStoredProcedureName;
        return this;
    }

    public Object sqlWriterTableType() {
        return this.sqlWriterTableType;
    }

    public AzureSqlSink withSqlWriterTableType(Object sqlWriterTableType) {
        this.sqlWriterTableType = sqlWriterTableType;
        return this;
    }

    public Object preCopyScript() {
        return this.preCopyScript;
    }

    public AzureSqlSink withPreCopyScript(Object preCopyScript) {
        this.preCopyScript = preCopyScript;
        return this;
    }

    public Object storedProcedureParameters() {
        return this.storedProcedureParameters;
    }

    public AzureSqlSink withStoredProcedureParameters(Object storedProcedureParameters) {
        this.storedProcedureParameters = storedProcedureParameters;
        return this;
    }

    public Object storedProcedureTableTypeParameterName() {
        return this.storedProcedureTableTypeParameterName;
    }

    public AzureSqlSink withStoredProcedureTableTypeParameterName(Object storedProcedureTableTypeParameterName) {
        this.storedProcedureTableTypeParameterName = storedProcedureTableTypeParameterName;
        return this;
    }

    public Object tableOption() {
        return this.tableOption;
    }

    public AzureSqlSink withTableOption(Object tableOption) {
        this.tableOption = tableOption;
        return this;
    }

    public Object sqlWriterUseTableLock() {
        return this.sqlWriterUseTableLock;
    }

    public AzureSqlSink withSqlWriterUseTableLock(Object sqlWriterUseTableLock) {
        this.sqlWriterUseTableLock = sqlWriterUseTableLock;
        return this;
    }

    public Object writeBehavior() {
        return this.writeBehavior;
    }

    public AzureSqlSink withWriteBehavior(Object writeBehavior) {
        this.writeBehavior = writeBehavior;
        return this;
    }

    public SqlUpsertSettings upsertSettings() {
        return this.upsertSettings;
    }

    public AzureSqlSink withUpsertSettings(SqlUpsertSettings upsertSettings) {
        this.upsertSettings = upsertSettings;
        return this;
    }

    @Override
    public AzureSqlSink withWriteBatchSize(Object writeBatchSize) {
        super.withWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public AzureSqlSink withWriteBatchTimeout(Object writeBatchTimeout) {
        super.withWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public AzureSqlSink withSinkRetryCount(Object sinkRetryCount) {
        super.withSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public AzureSqlSink withSinkRetryWait(Object sinkRetryWait) {
        super.withSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public AzureSqlSink withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public AzureSqlSink withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.upsertSettings() != null) {
            this.upsertSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.writeBatchSize() != null) {
            jsonWriter.writeUntypedField("writeBatchSize", this.writeBatchSize());
        }
        if (this.writeBatchTimeout() != null) {
            jsonWriter.writeUntypedField("writeBatchTimeout", this.writeBatchTimeout());
        }
        if (this.sinkRetryCount() != null) {
            jsonWriter.writeUntypedField("sinkRetryCount", this.sinkRetryCount());
        }
        if (this.sinkRetryWait() != null) {
            jsonWriter.writeUntypedField("sinkRetryWait", this.sinkRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.sqlWriterStoredProcedureName != null) {
            jsonWriter.writeUntypedField("sqlWriterStoredProcedureName", this.sqlWriterStoredProcedureName);
        }
        if (this.sqlWriterTableType != null) {
            jsonWriter.writeUntypedField("sqlWriterTableType", this.sqlWriterTableType);
        }
        if (this.preCopyScript != null) {
            jsonWriter.writeUntypedField("preCopyScript", this.preCopyScript);
        }
        if (this.storedProcedureParameters != null) {
            jsonWriter.writeUntypedField("storedProcedureParameters", this.storedProcedureParameters);
        }
        if (this.storedProcedureTableTypeParameterName != null) {
            jsonWriter.writeUntypedField("storedProcedureTableTypeParameterName", this.storedProcedureTableTypeParameterName);
        }
        if (this.tableOption != null) {
            jsonWriter.writeUntypedField("tableOption", this.tableOption);
        }
        if (this.sqlWriterUseTableLock != null) {
            jsonWriter.writeUntypedField("sqlWriterUseTableLock", this.sqlWriterUseTableLock);
        }
        if (this.writeBehavior != null) {
            jsonWriter.writeUntypedField("writeBehavior", this.writeBehavior);
        }
        jsonWriter.writeJsonField("upsertSettings", (JsonSerializable)this.upsertSettings);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureSqlSink fromJson(JsonReader jsonReader) throws IOException {
        return (AzureSqlSink)jsonReader.readObject(reader -> {
            AzureSqlSink deserializedAzureSqlSink = new AzureSqlSink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedAzureSqlSink.withWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedAzureSqlSink.withWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedAzureSqlSink.withSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedAzureSqlSink.withSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAzureSqlSink.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedAzureSqlSink.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureSqlSink.type = reader.getString();
                    continue;
                }
                if ("sqlWriterStoredProcedureName".equals(fieldName)) {
                    deserializedAzureSqlSink.sqlWriterStoredProcedureName = reader.readUntyped();
                    continue;
                }
                if ("sqlWriterTableType".equals(fieldName)) {
                    deserializedAzureSqlSink.sqlWriterTableType = reader.readUntyped();
                    continue;
                }
                if ("preCopyScript".equals(fieldName)) {
                    deserializedAzureSqlSink.preCopyScript = reader.readUntyped();
                    continue;
                }
                if ("storedProcedureParameters".equals(fieldName)) {
                    deserializedAzureSqlSink.storedProcedureParameters = reader.readUntyped();
                    continue;
                }
                if ("storedProcedureTableTypeParameterName".equals(fieldName)) {
                    deserializedAzureSqlSink.storedProcedureTableTypeParameterName = reader.readUntyped();
                    continue;
                }
                if ("tableOption".equals(fieldName)) {
                    deserializedAzureSqlSink.tableOption = reader.readUntyped();
                    continue;
                }
                if ("sqlWriterUseTableLock".equals(fieldName)) {
                    deserializedAzureSqlSink.sqlWriterUseTableLock = reader.readUntyped();
                    continue;
                }
                if ("writeBehavior".equals(fieldName)) {
                    deserializedAzureSqlSink.writeBehavior = reader.readUntyped();
                    continue;
                }
                if ("upsertSettings".equals(fieldName)) {
                    deserializedAzureSqlSink.upsertSettings = SqlUpsertSettings.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureSqlSink.withAdditionalProperties(additionalProperties);
            return deserializedAzureSqlSink;
        });
    }
}

