/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ActivityRun
implements JsonSerializable<ActivityRun> {
    private String pipelineName;
    private String pipelineRunId;
    private String activityName;
    private String activityType;
    private String activityRunId;
    private String linkedServiceName;
    private String status;
    private OffsetDateTime activityRunStart;
    private OffsetDateTime activityRunEnd;
    private Integer durationInMs;
    private Object input;
    private Object output;
    private Object error;
    private Map<String, Object> additionalProperties;

    public String pipelineName() {
        return this.pipelineName;
    }

    public String pipelineRunId() {
        return this.pipelineRunId;
    }

    public String activityName() {
        return this.activityName;
    }

    public String activityType() {
        return this.activityType;
    }

    public String activityRunId() {
        return this.activityRunId;
    }

    public String linkedServiceName() {
        return this.linkedServiceName;
    }

    public String status() {
        return this.status;
    }

    public OffsetDateTime activityRunStart() {
        return this.activityRunStart;
    }

    public OffsetDateTime activityRunEnd() {
        return this.activityRunEnd;
    }

    public Integer durationInMs() {
        return this.durationInMs;
    }

    public Object input() {
        return this.input;
    }

    public Object output() {
        return this.output;
    }

    public Object error() {
        return this.error;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public ActivityRun withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ActivityRun fromJson(JsonReader jsonReader) throws IOException {
        return (ActivityRun)jsonReader.readObject(reader -> {
            ActivityRun deserializedActivityRun = new ActivityRun();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("pipelineName".equals(fieldName)) {
                    deserializedActivityRun.pipelineName = reader.getString();
                    continue;
                }
                if ("pipelineRunId".equals(fieldName)) {
                    deserializedActivityRun.pipelineRunId = reader.getString();
                    continue;
                }
                if ("activityName".equals(fieldName)) {
                    deserializedActivityRun.activityName = reader.getString();
                    continue;
                }
                if ("activityType".equals(fieldName)) {
                    deserializedActivityRun.activityType = reader.getString();
                    continue;
                }
                if ("activityRunId".equals(fieldName)) {
                    deserializedActivityRun.activityRunId = reader.getString();
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedActivityRun.linkedServiceName = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedActivityRun.status = reader.getString();
                    continue;
                }
                if ("activityRunStart".equals(fieldName)) {
                    deserializedActivityRun.activityRunStart = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("activityRunEnd".equals(fieldName)) {
                    deserializedActivityRun.activityRunEnd = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("durationInMs".equals(fieldName)) {
                    deserializedActivityRun.durationInMs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("input".equals(fieldName)) {
                    deserializedActivityRun.input = reader.readUntyped();
                    continue;
                }
                if ("output".equals(fieldName)) {
                    deserializedActivityRun.output = reader.readUntyped();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedActivityRun.error = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedActivityRun.additionalProperties = additionalProperties;
            return deserializedActivityRun;
        });
    }
}

