/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.models.PrivateEndpointConnectionResourceInner;
import com.azure.resourcemanager.datafactory.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datafactory.models.PrivateEndpointConnectionResource;
import com.azure.resourcemanager.datafactory.models.PrivateLinkConnectionApprovalRequest;
import com.azure.resourcemanager.datafactory.models.PrivateLinkConnectionApprovalRequestResource;
import com.azure.resourcemanager.datafactory.models.RemotePrivateEndpointConnection;

public final class PrivateEndpointConnectionResourceImpl
implements PrivateEndpointConnectionResource,
PrivateEndpointConnectionResource.Definition,
PrivateEndpointConnectionResource.Update {
    private PrivateEndpointConnectionResourceInner innerObject;
    private final DataFactoryManager serviceManager;
    private String resourceGroupName;
    private String factoryName;
    private String privateEndpointConnectionName;
    private String createIfMatch;
    private PrivateLinkConnectionApprovalRequestResource createPrivateEndpointWrapper;
    private String updateIfMatch;
    private PrivateLinkConnectionApprovalRequestResource updatePrivateEndpointWrapper;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public RemotePrivateEndpointConnection properties() {
        return this.innerModel().properties();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public PrivateEndpointConnectionResourceInner innerModel() {
        return this.innerObject;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public PrivateEndpointConnectionResourceImpl withExistingFactory(String resourceGroupName, String factoryName) {
        this.resourceGroupName = resourceGroupName;
        this.factoryName = factoryName;
        return this;
    }

    @Override
    public PrivateEndpointConnectionResource create() {
        this.innerObject = (PrivateEndpointConnectionResourceInner)((Object)this.serviceManager.serviceClient().getPrivateEndpointConnectionOperations().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.privateEndpointConnectionName, this.createPrivateEndpointWrapper, this.createIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public PrivateEndpointConnectionResource create(Context context) {
        this.innerObject = (PrivateEndpointConnectionResourceInner)((Object)this.serviceManager.serviceClient().getPrivateEndpointConnectionOperations().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.privateEndpointConnectionName, this.createPrivateEndpointWrapper, this.createIfMatch, context).getValue());
        return this;
    }

    PrivateEndpointConnectionResourceImpl(String name, DataFactoryManager serviceManager) {
        this.innerObject = new PrivateEndpointConnectionResourceInner();
        this.serviceManager = serviceManager;
        this.privateEndpointConnectionName = name;
        this.createIfMatch = null;
        this.createPrivateEndpointWrapper = new PrivateLinkConnectionApprovalRequestResource();
    }

    @Override
    public PrivateEndpointConnectionResourceImpl update() {
        this.updateIfMatch = null;
        this.updatePrivateEndpointWrapper = new PrivateLinkConnectionApprovalRequestResource();
        return this;
    }

    @Override
    public PrivateEndpointConnectionResource apply() {
        this.innerObject = (PrivateEndpointConnectionResourceInner)((Object)this.serviceManager.serviceClient().getPrivateEndpointConnectionOperations().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.privateEndpointConnectionName, this.updatePrivateEndpointWrapper, this.updateIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public PrivateEndpointConnectionResource apply(Context context) {
        this.innerObject = (PrivateEndpointConnectionResourceInner)((Object)this.serviceManager.serviceClient().getPrivateEndpointConnectionOperations().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.privateEndpointConnectionName, this.updatePrivateEndpointWrapper, this.updateIfMatch, context).getValue());
        return this;
    }

    PrivateEndpointConnectionResourceImpl(PrivateEndpointConnectionResourceInner innerObject, DataFactoryManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.factoryName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "factories");
        this.privateEndpointConnectionName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "privateEndpointConnections");
    }

    @Override
    public PrivateEndpointConnectionResource refresh() {
        String localIfNoneMatch = null;
        this.innerObject = (PrivateEndpointConnectionResourceInner)((Object)this.serviceManager.serviceClient().getPrivateEndpointConnectionOperations().getWithResponse(this.resourceGroupName, this.factoryName, this.privateEndpointConnectionName, localIfNoneMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public PrivateEndpointConnectionResource refresh(Context context) {
        String localIfNoneMatch = null;
        this.innerObject = (PrivateEndpointConnectionResourceInner)((Object)this.serviceManager.serviceClient().getPrivateEndpointConnectionOperations().getWithResponse(this.resourceGroupName, this.factoryName, this.privateEndpointConnectionName, localIfNoneMatch, context).getValue());
        return this;
    }

    @Override
    public PrivateEndpointConnectionResourceImpl withProperties(PrivateLinkConnectionApprovalRequest properties) {
        if (this.isInCreateMode()) {
            this.createPrivateEndpointWrapper.withProperties(properties);
            return this;
        }
        this.updatePrivateEndpointWrapper.withProperties(properties);
        return this;
    }

    @Override
    public PrivateEndpointConnectionResourceImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

