/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.management.polling.SyncPollerFactory;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.datafactory.fluent.ActivityRunsClient;
import com.azure.resourcemanager.datafactory.fluent.ChangeDataCapturesClient;
import com.azure.resourcemanager.datafactory.fluent.CredentialOperationsClient;
import com.azure.resourcemanager.datafactory.fluent.DataFactoryManagementClient;
import com.azure.resourcemanager.datafactory.fluent.DataFlowDebugSessionsClient;
import com.azure.resourcemanager.datafactory.fluent.DataFlowsClient;
import com.azure.resourcemanager.datafactory.fluent.DatasetsClient;
import com.azure.resourcemanager.datafactory.fluent.ExposureControlsClient;
import com.azure.resourcemanager.datafactory.fluent.FactoriesClient;
import com.azure.resourcemanager.datafactory.fluent.GlobalParametersClient;
import com.azure.resourcemanager.datafactory.fluent.IntegrationRuntimeNodesClient;
import com.azure.resourcemanager.datafactory.fluent.IntegrationRuntimeObjectMetadatasClient;
import com.azure.resourcemanager.datafactory.fluent.IntegrationRuntimesClient;
import com.azure.resourcemanager.datafactory.fluent.LinkedServicesClient;
import com.azure.resourcemanager.datafactory.fluent.ManagedPrivateEndpointsClient;
import com.azure.resourcemanager.datafactory.fluent.ManagedVirtualNetworksClient;
import com.azure.resourcemanager.datafactory.fluent.OperationsClient;
import com.azure.resourcemanager.datafactory.fluent.PipelineRunsClient;
import com.azure.resourcemanager.datafactory.fluent.PipelinesClient;
import com.azure.resourcemanager.datafactory.fluent.PrivateEndPointConnectionsClient;
import com.azure.resourcemanager.datafactory.fluent.PrivateEndpointConnectionOperationsClient;
import com.azure.resourcemanager.datafactory.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.datafactory.fluent.TriggerRunsClient;
import com.azure.resourcemanager.datafactory.fluent.TriggersClient;
import com.azure.resourcemanager.datafactory.implementation.ActivityRunsClientImpl;
import com.azure.resourcemanager.datafactory.implementation.ChangeDataCapturesClientImpl;
import com.azure.resourcemanager.datafactory.implementation.CredentialOperationsClientImpl;
import com.azure.resourcemanager.datafactory.implementation.DataFactoryManagementClientBuilder;
import com.azure.resourcemanager.datafactory.implementation.DataFlowDebugSessionsClientImpl;
import com.azure.resourcemanager.datafactory.implementation.DataFlowsClientImpl;
import com.azure.resourcemanager.datafactory.implementation.DatasetsClientImpl;
import com.azure.resourcemanager.datafactory.implementation.ExposureControlsClientImpl;
import com.azure.resourcemanager.datafactory.implementation.FactoriesClientImpl;
import com.azure.resourcemanager.datafactory.implementation.GlobalParametersClientImpl;
import com.azure.resourcemanager.datafactory.implementation.IntegrationRuntimeNodesClientImpl;
import com.azure.resourcemanager.datafactory.implementation.IntegrationRuntimeObjectMetadatasClientImpl;
import com.azure.resourcemanager.datafactory.implementation.IntegrationRuntimesClientImpl;
import com.azure.resourcemanager.datafactory.implementation.LinkedServicesClientImpl;
import com.azure.resourcemanager.datafactory.implementation.ManagedPrivateEndpointsClientImpl;
import com.azure.resourcemanager.datafactory.implementation.ManagedVirtualNetworksClientImpl;
import com.azure.resourcemanager.datafactory.implementation.OperationsClientImpl;
import com.azure.resourcemanager.datafactory.implementation.PipelineRunsClientImpl;
import com.azure.resourcemanager.datafactory.implementation.PipelinesClientImpl;
import com.azure.resourcemanager.datafactory.implementation.PrivateEndPointConnectionsClientImpl;
import com.azure.resourcemanager.datafactory.implementation.PrivateEndpointConnectionOperationsClientImpl;
import com.azure.resourcemanager.datafactory.implementation.PrivateLinkResourcesClientImpl;
import com.azure.resourcemanager.datafactory.implementation.TriggerRunsClientImpl;
import com.azure.resourcemanager.datafactory.implementation.TriggersClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DataFactoryManagementClientBuilder.class)
public final class DataFactoryManagementClientImpl
implements DataFactoryManagementClient {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final OperationsClient operations;
    private final FactoriesClient factories;
    private final ExposureControlsClient exposureControls;
    private final IntegrationRuntimesClient integrationRuntimes;
    private final IntegrationRuntimeObjectMetadatasClient integrationRuntimeObjectMetadatas;
    private final IntegrationRuntimeNodesClient integrationRuntimeNodes;
    private final LinkedServicesClient linkedServices;
    private final DatasetsClient datasets;
    private final PipelinesClient pipelines;
    private final PipelineRunsClient pipelineRuns;
    private final ActivityRunsClient activityRuns;
    private final TriggersClient triggers;
    private final TriggerRunsClient triggerRuns;
    private final DataFlowsClient dataFlows;
    private final DataFlowDebugSessionsClient dataFlowDebugSessions;
    private final ManagedVirtualNetworksClient managedVirtualNetworks;
    private final ManagedPrivateEndpointsClient managedPrivateEndpoints;
    private final CredentialOperationsClient credentialOperations;
    private final PrivateEndPointConnectionsClient privateEndPointConnections;
    private final PrivateEndpointConnectionOperationsClient privateEndpointConnectionOperations;
    private final PrivateLinkResourcesClient privateLinkResources;
    private final GlobalParametersClient globalParameters;
    private final ChangeDataCapturesClient changeDataCaptures;
    private static final ClientLogger LOGGER = new ClientLogger(DataFactoryManagementClientImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public FactoriesClient getFactories() {
        return this.factories;
    }

    @Override
    public ExposureControlsClient getExposureControls() {
        return this.exposureControls;
    }

    @Override
    public IntegrationRuntimesClient getIntegrationRuntimes() {
        return this.integrationRuntimes;
    }

    @Override
    public IntegrationRuntimeObjectMetadatasClient getIntegrationRuntimeObjectMetadatas() {
        return this.integrationRuntimeObjectMetadatas;
    }

    @Override
    public IntegrationRuntimeNodesClient getIntegrationRuntimeNodes() {
        return this.integrationRuntimeNodes;
    }

    @Override
    public LinkedServicesClient getLinkedServices() {
        return this.linkedServices;
    }

    @Override
    public DatasetsClient getDatasets() {
        return this.datasets;
    }

    @Override
    public PipelinesClient getPipelines() {
        return this.pipelines;
    }

    @Override
    public PipelineRunsClient getPipelineRuns() {
        return this.pipelineRuns;
    }

    @Override
    public ActivityRunsClient getActivityRuns() {
        return this.activityRuns;
    }

    @Override
    public TriggersClient getTriggers() {
        return this.triggers;
    }

    @Override
    public TriggerRunsClient getTriggerRuns() {
        return this.triggerRuns;
    }

    @Override
    public DataFlowsClient getDataFlows() {
        return this.dataFlows;
    }

    @Override
    public DataFlowDebugSessionsClient getDataFlowDebugSessions() {
        return this.dataFlowDebugSessions;
    }

    @Override
    public ManagedVirtualNetworksClient getManagedVirtualNetworks() {
        return this.managedVirtualNetworks;
    }

    @Override
    public ManagedPrivateEndpointsClient getManagedPrivateEndpoints() {
        return this.managedPrivateEndpoints;
    }

    @Override
    public CredentialOperationsClient getCredentialOperations() {
        return this.credentialOperations;
    }

    @Override
    public PrivateEndPointConnectionsClient getPrivateEndPointConnections() {
        return this.privateEndPointConnections;
    }

    @Override
    public PrivateEndpointConnectionOperationsClient getPrivateEndpointConnectionOperations() {
        return this.privateEndpointConnectionOperations;
    }

    @Override
    public PrivateLinkResourcesClient getPrivateLinkResources() {
        return this.privateLinkResources;
    }

    @Override
    public GlobalParametersClient getGlobalParameters() {
        return this.globalParameters;
    }

    @Override
    public ChangeDataCapturesClient getChangeDataCaptures() {
        return this.changeDataCaptures;
    }

    DataFactoryManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2018-06-01";
        this.operations = new OperationsClientImpl(this);
        this.factories = new FactoriesClientImpl(this);
        this.exposureControls = new ExposureControlsClientImpl(this);
        this.integrationRuntimes = new IntegrationRuntimesClientImpl(this);
        this.integrationRuntimeObjectMetadatas = new IntegrationRuntimeObjectMetadatasClientImpl(this);
        this.integrationRuntimeNodes = new IntegrationRuntimeNodesClientImpl(this);
        this.linkedServices = new LinkedServicesClientImpl(this);
        this.datasets = new DatasetsClientImpl(this);
        this.pipelines = new PipelinesClientImpl(this);
        this.pipelineRuns = new PipelineRunsClientImpl(this);
        this.activityRuns = new ActivityRunsClientImpl(this);
        this.triggers = new TriggersClientImpl(this);
        this.triggerRuns = new TriggerRunsClientImpl(this);
        this.dataFlows = new DataFlowsClientImpl(this);
        this.dataFlowDebugSessions = new DataFlowDebugSessionsClientImpl(this);
        this.managedVirtualNetworks = new ManagedVirtualNetworksClientImpl(this);
        this.managedPrivateEndpoints = new ManagedPrivateEndpointsClientImpl(this);
        this.credentialOperations = new CredentialOperationsClientImpl(this);
        this.privateEndPointConnections = new PrivateEndPointConnectionsClientImpl(this);
        this.privateEndpointConnectionOperations = new PrivateEndpointConnectionOperationsClientImpl(this);
        this.privateLinkResources = new PrivateLinkResourcesClientImpl(this);
        this.globalParameters = new GlobalParametersClientImpl(this);
        this.changeDataCaptures = new ChangeDataCapturesClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> SyncPoller<PollResult<T>, U> getLroResult(Response<BinaryData> activationResponse, Type pollResultType, Type finalResultType, Context context) {
        return SyncPollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)this.httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, () -> activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

