/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class SharePointOnlineListLinkedServiceTypeProperties
implements JsonSerializable<SharePointOnlineListLinkedServiceTypeProperties> {
    private Object siteUrl;
    private Object tenantId;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object servicePrincipalCredentialType;
    private SecretBase servicePrincipalEmbeddedCert;
    private SecretBase servicePrincipalEmbeddedCertPassword;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(SharePointOnlineListLinkedServiceTypeProperties.class);

    public Object siteUrl() {
        return this.siteUrl;
    }

    public SharePointOnlineListLinkedServiceTypeProperties withSiteUrl(Object siteUrl) {
        this.siteUrl = siteUrl;
        return this;
    }

    public Object tenantId() {
        return this.tenantId;
    }

    public SharePointOnlineListLinkedServiceTypeProperties withTenantId(Object tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    public SharePointOnlineListLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public SharePointOnlineListLinkedServiceTypeProperties withServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object servicePrincipalCredentialType() {
        return this.servicePrincipalCredentialType;
    }

    public SharePointOnlineListLinkedServiceTypeProperties withServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        this.servicePrincipalCredentialType = servicePrincipalCredentialType;
        return this;
    }

    public SecretBase servicePrincipalEmbeddedCert() {
        return this.servicePrincipalEmbeddedCert;
    }

    public SharePointOnlineListLinkedServiceTypeProperties withServicePrincipalEmbeddedCert(SecretBase servicePrincipalEmbeddedCert) {
        this.servicePrincipalEmbeddedCert = servicePrincipalEmbeddedCert;
        return this;
    }

    public SecretBase servicePrincipalEmbeddedCertPassword() {
        return this.servicePrincipalEmbeddedCertPassword;
    }

    public SharePointOnlineListLinkedServiceTypeProperties withServicePrincipalEmbeddedCertPassword(SecretBase servicePrincipalEmbeddedCertPassword) {
        this.servicePrincipalEmbeddedCertPassword = servicePrincipalEmbeddedCertPassword;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public SharePointOnlineListLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.siteUrl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property siteUrl in model SharePointOnlineListLinkedServiceTypeProperties"));
        }
        if (this.tenantId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property tenantId in model SharePointOnlineListLinkedServiceTypeProperties"));
        }
        if (this.servicePrincipalId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property servicePrincipalId in model SharePointOnlineListLinkedServiceTypeProperties"));
        }
        if (this.servicePrincipalKey() != null) {
            this.servicePrincipalKey().validate();
        }
        if (this.servicePrincipalEmbeddedCert() != null) {
            this.servicePrincipalEmbeddedCert().validate();
        }
        if (this.servicePrincipalEmbeddedCertPassword() != null) {
            this.servicePrincipalEmbeddedCertPassword().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("siteUrl", this.siteUrl);
        jsonWriter.writeUntypedField("tenantId", this.tenantId);
        jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
        if (this.servicePrincipalCredentialType != null) {
            jsonWriter.writeUntypedField("servicePrincipalCredentialType", this.servicePrincipalCredentialType);
        }
        jsonWriter.writeJsonField("servicePrincipalEmbeddedCert", (JsonSerializable)this.servicePrincipalEmbeddedCert);
        jsonWriter.writeJsonField("servicePrincipalEmbeddedCertPassword", (JsonSerializable)this.servicePrincipalEmbeddedCertPassword);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static SharePointOnlineListLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SharePointOnlineListLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            SharePointOnlineListLinkedServiceTypeProperties deserializedSharePointOnlineListLinkedServiceTypeProperties = new SharePointOnlineListLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("siteUrl".equals(fieldName)) {
                    deserializedSharePointOnlineListLinkedServiceTypeProperties.siteUrl = reader.readUntyped();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedSharePointOnlineListLinkedServiceTypeProperties.tenantId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedSharePointOnlineListLinkedServiceTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalKey".equals(fieldName)) {
                    deserializedSharePointOnlineListLinkedServiceTypeProperties.servicePrincipalKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("servicePrincipalCredentialType".equals(fieldName)) {
                    deserializedSharePointOnlineListLinkedServiceTypeProperties.servicePrincipalCredentialType = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalEmbeddedCert".equals(fieldName)) {
                    deserializedSharePointOnlineListLinkedServiceTypeProperties.servicePrincipalEmbeddedCert = SecretBase.fromJson(reader);
                    continue;
                }
                if ("servicePrincipalEmbeddedCertPassword".equals(fieldName)) {
                    deserializedSharePointOnlineListLinkedServiceTypeProperties.servicePrincipalEmbeddedCertPassword = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedSharePointOnlineListLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSharePointOnlineListLinkedServiceTypeProperties;
        });
    }
}

