/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import java.io.IOException;

public final class ServicePrincipalCredentialTypeProperties
implements JsonSerializable<ServicePrincipalCredentialTypeProperties> {
    private Object servicePrincipalId;
    private AzureKeyVaultSecretReference servicePrincipalKey;
    private Object tenant;

    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    public ServicePrincipalCredentialTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public AzureKeyVaultSecretReference servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public ServicePrincipalCredentialTypeProperties withServicePrincipalKey(AzureKeyVaultSecretReference servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object tenant() {
        return this.tenant;
    }

    public ServicePrincipalCredentialTypeProperties withTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public void validate() {
        if (this.servicePrincipalKey() != null) {
            this.servicePrincipalKey().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.servicePrincipalId != null) {
            jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        }
        jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
        if (this.tenant != null) {
            jsonWriter.writeUntypedField("tenant", this.tenant);
        }
        return jsonWriter.writeEndObject();
    }

    public static ServicePrincipalCredentialTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ServicePrincipalCredentialTypeProperties)jsonReader.readObject(reader -> {
            ServicePrincipalCredentialTypeProperties deserializedServicePrincipalCredentialTypeProperties = new ServicePrincipalCredentialTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedServicePrincipalCredentialTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalKey".equals(fieldName)) {
                    deserializedServicePrincipalCredentialTypeProperties.servicePrincipalKey = AzureKeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("tenant".equals(fieldName)) {
                    deserializedServicePrincipalCredentialTypeProperties.tenant = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServicePrincipalCredentialTypeProperties;
        });
    }
}

