/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.ServiceNowV2AuthenticationType;
import java.io.IOException;

public final class ServiceNowV2LinkedServiceTypeProperties
implements JsonSerializable<ServiceNowV2LinkedServiceTypeProperties> {
    private Object endpoint;
    private ServiceNowV2AuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private Object clientId;
    private SecretBase clientSecret;
    private Object grantType;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(ServiceNowV2LinkedServiceTypeProperties.class);

    public Object endpoint() {
        return this.endpoint;
    }

    public ServiceNowV2LinkedServiceTypeProperties withEndpoint(Object endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public ServiceNowV2AuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public ServiceNowV2LinkedServiceTypeProperties withAuthenticationType(ServiceNowV2AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public ServiceNowV2LinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public ServiceNowV2LinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object clientId() {
        return this.clientId;
    }

    public ServiceNowV2LinkedServiceTypeProperties withClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase clientSecret() {
        return this.clientSecret;
    }

    public ServiceNowV2LinkedServiceTypeProperties withClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public Object grantType() {
        return this.grantType;
    }

    public ServiceNowV2LinkedServiceTypeProperties withGrantType(Object grantType) {
        this.grantType = grantType;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public ServiceNowV2LinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.endpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property endpoint in model ServiceNowV2LinkedServiceTypeProperties"));
        }
        if (this.authenticationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property authenticationType in model ServiceNowV2LinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
        if (this.clientSecret() != null) {
            this.clientSecret().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("endpoint", this.endpoint);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        if (this.username != null) {
            jsonWriter.writeUntypedField("username", this.username);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        if (this.clientId != null) {
            jsonWriter.writeUntypedField("clientId", this.clientId);
        }
        jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
        if (this.grantType != null) {
            jsonWriter.writeUntypedField("grantType", this.grantType);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static ServiceNowV2LinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ServiceNowV2LinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            ServiceNowV2LinkedServiceTypeProperties deserializedServiceNowV2LinkedServiceTypeProperties = new ServiceNowV2LinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpoint".equals(fieldName)) {
                    deserializedServiceNowV2LinkedServiceTypeProperties.endpoint = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedServiceNowV2LinkedServiceTypeProperties.authenticationType = ServiceNowV2AuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedServiceNowV2LinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedServiceNowV2LinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedServiceNowV2LinkedServiceTypeProperties.clientId = reader.readUntyped();
                    continue;
                }
                if ("clientSecret".equals(fieldName)) {
                    deserializedServiceNowV2LinkedServiceTypeProperties.clientSecret = SecretBase.fromJson(reader);
                    continue;
                }
                if ("grantType".equals(fieldName)) {
                    deserializedServiceNowV2LinkedServiceTypeProperties.grantType = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedServiceNowV2LinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServiceNowV2LinkedServiceTypeProperties;
        });
    }
}

