/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeUpdateResult;
import com.azure.resourcemanager.datafactory.models.SelfHostedIntegrationRuntimeNodeStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SelfHostedIntegrationRuntimeNodeInner
implements JsonSerializable<SelfHostedIntegrationRuntimeNodeInner> {
    private String nodeName;
    private String machineName;
    private String hostServiceUri;
    private SelfHostedIntegrationRuntimeNodeStatus status;
    private Map<String, String> capabilities;
    private String versionStatus;
    private String version;
    private OffsetDateTime registerTime;
    private OffsetDateTime lastConnectTime;
    private OffsetDateTime expiryTime;
    private OffsetDateTime lastStartTime;
    private OffsetDateTime lastStopTime;
    private IntegrationRuntimeUpdateResult lastUpdateResult;
    private OffsetDateTime lastStartUpdateTime;
    private OffsetDateTime lastEndUpdateTime;
    private Boolean isActiveDispatcher;
    private Integer concurrentJobsLimit;
    private Integer maxConcurrentJobs;
    private Map<String, Object> additionalProperties;

    public String nodeName() {
        return this.nodeName;
    }

    public String machineName() {
        return this.machineName;
    }

    public String hostServiceUri() {
        return this.hostServiceUri;
    }

    public SelfHostedIntegrationRuntimeNodeStatus status() {
        return this.status;
    }

    public Map<String, String> capabilities() {
        return this.capabilities;
    }

    public String versionStatus() {
        return this.versionStatus;
    }

    public String version() {
        return this.version;
    }

    public OffsetDateTime registerTime() {
        return this.registerTime;
    }

    public OffsetDateTime lastConnectTime() {
        return this.lastConnectTime;
    }

    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    public OffsetDateTime lastStartTime() {
        return this.lastStartTime;
    }

    public OffsetDateTime lastStopTime() {
        return this.lastStopTime;
    }

    public IntegrationRuntimeUpdateResult lastUpdateResult() {
        return this.lastUpdateResult;
    }

    public OffsetDateTime lastStartUpdateTime() {
        return this.lastStartUpdateTime;
    }

    public OffsetDateTime lastEndUpdateTime() {
        return this.lastEndUpdateTime;
    }

    public Boolean isActiveDispatcher() {
        return this.isActiveDispatcher;
    }

    public Integer concurrentJobsLimit() {
        return this.concurrentJobsLimit;
    }

    public Integer maxConcurrentJobs() {
        return this.maxConcurrentJobs;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public SelfHostedIntegrationRuntimeNodeInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SelfHostedIntegrationRuntimeNodeInner fromJson(JsonReader jsonReader) throws IOException {
        return (SelfHostedIntegrationRuntimeNodeInner)jsonReader.readObject(reader -> {
            SelfHostedIntegrationRuntimeNodeInner deserializedSelfHostedIntegrationRuntimeNodeInner = new SelfHostedIntegrationRuntimeNodeInner();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nodeName".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeNodeInner.nodeName = reader.getString();
                    continue;
                }
                if ("machineName".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeNodeInner.machineName = reader.getString();
                    continue;
                }
                if ("hostServiceUri".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeNodeInner.hostServiceUri = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeNodeInner.status = SelfHostedIntegrationRuntimeNodeStatus.fromString(reader.getString());
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    Map capabilities;
                    deserializedSelfHostedIntegrationRuntimeNodeInner.capabilities = capabilities = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("versionStatus".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeNodeInner.versionStatus = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeNodeInner.version = reader.getString();
                    continue;
                }
                if ("registerTime".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeNodeInner.registerTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastConnectTime".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeNodeInner.lastConnectTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("expiryTime".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeNodeInner.expiryTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastStartTime".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeNodeInner.lastStartTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastStopTime".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeNodeInner.lastStopTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdateResult".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeNodeInner.lastUpdateResult = IntegrationRuntimeUpdateResult.fromString(reader.getString());
                    continue;
                }
                if ("lastStartUpdateTime".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeNodeInner.lastStartUpdateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastEndUpdateTime".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeNodeInner.lastEndUpdateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("isActiveDispatcher".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeNodeInner.isActiveDispatcher = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("concurrentJobsLimit".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeNodeInner.concurrentJobsLimit = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxConcurrentJobs".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeNodeInner.maxConcurrentJobs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSelfHostedIntegrationRuntimeNodeInner.additionalProperties = additionalProperties;
            return deserializedSelfHostedIntegrationRuntimeNodeInner;
        });
    }
}

