/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import java.io.IOException;

public final class ParquetDatasetTypeProperties
implements JsonSerializable<ParquetDatasetTypeProperties> {
    private DatasetLocation location;
    private Object compressionCodec;
    private static final ClientLogger LOGGER = new ClientLogger(ParquetDatasetTypeProperties.class);

    public DatasetLocation location() {
        return this.location;
    }

    public ParquetDatasetTypeProperties withLocation(DatasetLocation location) {
        this.location = location;
        return this;
    }

    public Object compressionCodec() {
        return this.compressionCodec;
    }

    public ParquetDatasetTypeProperties withCompressionCodec(Object compressionCodec) {
        this.compressionCodec = compressionCodec;
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model ParquetDatasetTypeProperties"));
        }
        this.location().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("location", (JsonSerializable)this.location);
        if (this.compressionCodec != null) {
            jsonWriter.writeUntypedField("compressionCodec", this.compressionCodec);
        }
        return jsonWriter.writeEndObject();
    }

    public static ParquetDatasetTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ParquetDatasetTypeProperties)jsonReader.readObject(reader -> {
            ParquetDatasetTypeProperties deserializedParquetDatasetTypeProperties = new ParquetDatasetTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedParquetDatasetTypeProperties.location = DatasetLocation.fromJson(reader);
                    continue;
                }
                if ("compressionCodec".equals(fieldName)) {
                    deserializedParquetDatasetTypeProperties.compressionCodec = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedParquetDatasetTypeProperties;
        });
    }
}

