/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import java.io.IOException;

public final class OrcDatasetTypeProperties
implements JsonSerializable<OrcDatasetTypeProperties> {
    private DatasetLocation location;
    private Object orcCompressionCodec;
    private static final ClientLogger LOGGER = new ClientLogger(OrcDatasetTypeProperties.class);

    public DatasetLocation location() {
        return this.location;
    }

    public OrcDatasetTypeProperties withLocation(DatasetLocation location) {
        this.location = location;
        return this;
    }

    public Object orcCompressionCodec() {
        return this.orcCompressionCodec;
    }

    public OrcDatasetTypeProperties withOrcCompressionCodec(Object orcCompressionCodec) {
        this.orcCompressionCodec = orcCompressionCodec;
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model OrcDatasetTypeProperties"));
        }
        this.location().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("location", (JsonSerializable)this.location);
        if (this.orcCompressionCodec != null) {
            jsonWriter.writeUntypedField("orcCompressionCodec", this.orcCompressionCodec);
        }
        return jsonWriter.writeEndObject();
    }

    public static OrcDatasetTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (OrcDatasetTypeProperties)jsonReader.readObject(reader -> {
            OrcDatasetTypeProperties deserializedOrcDatasetTypeProperties = new OrcDatasetTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedOrcDatasetTypeProperties.location = DatasetLocation.fromJson(reader);
                    continue;
                }
                if ("orcCompressionCodec".equals(fieldName)) {
                    deserializedOrcDatasetTypeProperties.orcCompressionCodec = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOrcDatasetTypeProperties;
        });
    }
}

