/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import java.io.IOException;

public final class MariaDBLinkedServiceTypeProperties
implements JsonSerializable<MariaDBLinkedServiceTypeProperties> {
    private Object driverVersion;
    private Object connectionString;
    private Object server;
    private Object port;
    private Object username;
    private Object database;
    private Object sslMode;
    private Object useSystemTrustStore;
    private AzureKeyVaultSecretReference password;
    private String encryptedCredential;

    public Object driverVersion() {
        return this.driverVersion;
    }

    public MariaDBLinkedServiceTypeProperties withDriverVersion(Object driverVersion) {
        this.driverVersion = driverVersion;
        return this;
    }

    public Object connectionString() {
        return this.connectionString;
    }

    public MariaDBLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public Object server() {
        return this.server;
    }

    public MariaDBLinkedServiceTypeProperties withServer(Object server) {
        this.server = server;
        return this;
    }

    public Object port() {
        return this.port;
    }

    public MariaDBLinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public MariaDBLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public Object database() {
        return this.database;
    }

    public MariaDBLinkedServiceTypeProperties withDatabase(Object database) {
        this.database = database;
        return this;
    }

    public Object sslMode() {
        return this.sslMode;
    }

    public MariaDBLinkedServiceTypeProperties withSslMode(Object sslMode) {
        this.sslMode = sslMode;
        return this;
    }

    public Object useSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    public MariaDBLinkedServiceTypeProperties withUseSystemTrustStore(Object useSystemTrustStore) {
        this.useSystemTrustStore = useSystemTrustStore;
        return this;
    }

    public AzureKeyVaultSecretReference password() {
        return this.password;
    }

    public MariaDBLinkedServiceTypeProperties withPassword(AzureKeyVaultSecretReference password) {
        this.password = password;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public MariaDBLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.driverVersion != null) {
            jsonWriter.writeUntypedField("driverVersion", this.driverVersion);
        }
        if (this.connectionString != null) {
            jsonWriter.writeUntypedField("connectionString", this.connectionString);
        }
        if (this.server != null) {
            jsonWriter.writeUntypedField("server", this.server);
        }
        if (this.port != null) {
            jsonWriter.writeUntypedField("port", this.port);
        }
        if (this.username != null) {
            jsonWriter.writeUntypedField("username", this.username);
        }
        if (this.database != null) {
            jsonWriter.writeUntypedField("database", this.database);
        }
        if (this.sslMode != null) {
            jsonWriter.writeUntypedField("sslMode", this.sslMode);
        }
        if (this.useSystemTrustStore != null) {
            jsonWriter.writeUntypedField("useSystemTrustStore", this.useSystemTrustStore);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static MariaDBLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MariaDBLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            MariaDBLinkedServiceTypeProperties deserializedMariaDBLinkedServiceTypeProperties = new MariaDBLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("driverVersion".equals(fieldName)) {
                    deserializedMariaDBLinkedServiceTypeProperties.driverVersion = reader.readUntyped();
                    continue;
                }
                if ("connectionString".equals(fieldName)) {
                    deserializedMariaDBLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("server".equals(fieldName)) {
                    deserializedMariaDBLinkedServiceTypeProperties.server = reader.readUntyped();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedMariaDBLinkedServiceTypeProperties.port = reader.readUntyped();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedMariaDBLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("database".equals(fieldName)) {
                    deserializedMariaDBLinkedServiceTypeProperties.database = reader.readUntyped();
                    continue;
                }
                if ("sslMode".equals(fieldName)) {
                    deserializedMariaDBLinkedServiceTypeProperties.sslMode = reader.readUntyped();
                    continue;
                }
                if ("useSystemTrustStore".equals(fieldName)) {
                    deserializedMariaDBLinkedServiceTypeProperties.useSystemTrustStore = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedMariaDBLinkedServiceTypeProperties.password = AzureKeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedMariaDBLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMariaDBLinkedServiceTypeProperties;
        });
    }
}

