/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import java.io.IOException;

public final class LinkedServiceResourceInner
extends SubResource {
    private LinkedService properties;
    private String name;
    private String type;
    private String etag;
    private static final ClientLogger LOGGER = new ClientLogger(LinkedServiceResourceInner.class);

    public LinkedService properties() {
        return this.properties;
    }

    public LinkedServiceResourceInner withProperties(LinkedService properties) {
        this.properties = properties;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String etag() {
        return this.etag;
    }

    public LinkedServiceResourceInner withId(String id) {
        super.withId(id);
        return this;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model LinkedServiceResourceInner"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static LinkedServiceResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (LinkedServiceResourceInner)((Object)jsonReader.readObject(reader -> {
            LinkedServiceResourceInner deserializedLinkedServiceResourceInner = new LinkedServiceResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedLinkedServiceResourceInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedLinkedServiceResourceInner.properties = LinkedService.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedLinkedServiceResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedLinkedServiceResourceInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedLinkedServiceResourceInner.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLinkedServiceResourceInner;
        }));
    }
}

