/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ScriptAction;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;
import java.util.List;

public final class HDInsightOnDemandLinkedServiceTypeProperties
implements JsonSerializable<HDInsightOnDemandLinkedServiceTypeProperties> {
    private Object clusterSize;
    private Object timeToLive;
    private Object version;
    private LinkedServiceReference linkedServiceName;
    private Object hostSubscriptionId;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object tenant;
    private Object clusterResourceGroup;
    private Object clusterNamePrefix;
    private Object clusterUsername;
    private SecretBase clusterPassword;
    private Object clusterSshUsername;
    private SecretBase clusterSshPassword;
    private List<LinkedServiceReference> additionalLinkedServiceNames;
    private LinkedServiceReference hcatalogLinkedServiceName;
    private Object clusterType;
    private Object sparkVersion;
    private Object coreConfiguration;
    private Object hBaseConfiguration;
    private Object hdfsConfiguration;
    private Object hiveConfiguration;
    private Object mapReduceConfiguration;
    private Object oozieConfiguration;
    private Object stormConfiguration;
    private Object yarnConfiguration;
    private String encryptedCredential;
    private Object headNodeSize;
    private Object dataNodeSize;
    private Object zookeeperNodeSize;
    private List<ScriptAction> scriptActions;
    private Object virtualNetworkId;
    private Object subnetName;
    private CredentialReference credential;
    private static final ClientLogger LOGGER = new ClientLogger(HDInsightOnDemandLinkedServiceTypeProperties.class);

    public Object clusterSize() {
        return this.clusterSize;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withClusterSize(Object clusterSize) {
        this.clusterSize = clusterSize;
        return this;
    }

    public Object timeToLive() {
        return this.timeToLive;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withTimeToLive(Object timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    public Object version() {
        return this.version;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withVersion(Object version) {
        this.version = version;
        return this;
    }

    public LinkedServiceReference linkedServiceName() {
        return this.linkedServiceName;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        this.linkedServiceName = linkedServiceName;
        return this;
    }

    public Object hostSubscriptionId() {
        return this.hostSubscriptionId;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withHostSubscriptionId(Object hostSubscriptionId) {
        this.hostSubscriptionId = hostSubscriptionId;
        return this;
    }

    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object tenant() {
        return this.tenant;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object clusterResourceGroup() {
        return this.clusterResourceGroup;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withClusterResourceGroup(Object clusterResourceGroup) {
        this.clusterResourceGroup = clusterResourceGroup;
        return this;
    }

    public Object clusterNamePrefix() {
        return this.clusterNamePrefix;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withClusterNamePrefix(Object clusterNamePrefix) {
        this.clusterNamePrefix = clusterNamePrefix;
        return this;
    }

    public Object clusterUsername() {
        return this.clusterUsername;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withClusterUsername(Object clusterUsername) {
        this.clusterUsername = clusterUsername;
        return this;
    }

    public SecretBase clusterPassword() {
        return this.clusterPassword;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withClusterPassword(SecretBase clusterPassword) {
        this.clusterPassword = clusterPassword;
        return this;
    }

    public Object clusterSshUsername() {
        return this.clusterSshUsername;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withClusterSshUsername(Object clusterSshUsername) {
        this.clusterSshUsername = clusterSshUsername;
        return this;
    }

    public SecretBase clusterSshPassword() {
        return this.clusterSshPassword;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withClusterSshPassword(SecretBase clusterSshPassword) {
        this.clusterSshPassword = clusterSshPassword;
        return this;
    }

    public List<LinkedServiceReference> additionalLinkedServiceNames() {
        return this.additionalLinkedServiceNames;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withAdditionalLinkedServiceNames(List<LinkedServiceReference> additionalLinkedServiceNames) {
        this.additionalLinkedServiceNames = additionalLinkedServiceNames;
        return this;
    }

    public LinkedServiceReference hcatalogLinkedServiceName() {
        return this.hcatalogLinkedServiceName;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withHcatalogLinkedServiceName(LinkedServiceReference hcatalogLinkedServiceName) {
        this.hcatalogLinkedServiceName = hcatalogLinkedServiceName;
        return this;
    }

    public Object clusterType() {
        return this.clusterType;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withClusterType(Object clusterType) {
        this.clusterType = clusterType;
        return this;
    }

    public Object sparkVersion() {
        return this.sparkVersion;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withSparkVersion(Object sparkVersion) {
        this.sparkVersion = sparkVersion;
        return this;
    }

    public Object coreConfiguration() {
        return this.coreConfiguration;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withCoreConfiguration(Object coreConfiguration) {
        this.coreConfiguration = coreConfiguration;
        return this;
    }

    public Object hBaseConfiguration() {
        return this.hBaseConfiguration;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withHBaseConfiguration(Object hBaseConfiguration) {
        this.hBaseConfiguration = hBaseConfiguration;
        return this;
    }

    public Object hdfsConfiguration() {
        return this.hdfsConfiguration;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withHdfsConfiguration(Object hdfsConfiguration) {
        this.hdfsConfiguration = hdfsConfiguration;
        return this;
    }

    public Object hiveConfiguration() {
        return this.hiveConfiguration;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withHiveConfiguration(Object hiveConfiguration) {
        this.hiveConfiguration = hiveConfiguration;
        return this;
    }

    public Object mapReduceConfiguration() {
        return this.mapReduceConfiguration;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withMapReduceConfiguration(Object mapReduceConfiguration) {
        this.mapReduceConfiguration = mapReduceConfiguration;
        return this;
    }

    public Object oozieConfiguration() {
        return this.oozieConfiguration;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withOozieConfiguration(Object oozieConfiguration) {
        this.oozieConfiguration = oozieConfiguration;
        return this;
    }

    public Object stormConfiguration() {
        return this.stormConfiguration;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withStormConfiguration(Object stormConfiguration) {
        this.stormConfiguration = stormConfiguration;
        return this;
    }

    public Object yarnConfiguration() {
        return this.yarnConfiguration;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withYarnConfiguration(Object yarnConfiguration) {
        this.yarnConfiguration = yarnConfiguration;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public Object headNodeSize() {
        return this.headNodeSize;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withHeadNodeSize(Object headNodeSize) {
        this.headNodeSize = headNodeSize;
        return this;
    }

    public Object dataNodeSize() {
        return this.dataNodeSize;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withDataNodeSize(Object dataNodeSize) {
        this.dataNodeSize = dataNodeSize;
        return this;
    }

    public Object zookeeperNodeSize() {
        return this.zookeeperNodeSize;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withZookeeperNodeSize(Object zookeeperNodeSize) {
        this.zookeeperNodeSize = zookeeperNodeSize;
        return this;
    }

    public List<ScriptAction> scriptActions() {
        return this.scriptActions;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withScriptActions(List<ScriptAction> scriptActions) {
        this.scriptActions = scriptActions;
        return this;
    }

    public Object virtualNetworkId() {
        return this.virtualNetworkId;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withVirtualNetworkId(Object virtualNetworkId) {
        this.virtualNetworkId = virtualNetworkId;
        return this;
    }

    public Object subnetName() {
        return this.subnetName;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withSubnetName(Object subnetName) {
        this.subnetName = subnetName;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public HDInsightOnDemandLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public void validate() {
        if (this.clusterSize() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property clusterSize in model HDInsightOnDemandLinkedServiceTypeProperties"));
        }
        if (this.timeToLive() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property timeToLive in model HDInsightOnDemandLinkedServiceTypeProperties"));
        }
        if (this.version() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property version in model HDInsightOnDemandLinkedServiceTypeProperties"));
        }
        if (this.linkedServiceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedServiceName in model HDInsightOnDemandLinkedServiceTypeProperties"));
        }
        this.linkedServiceName().validate();
        if (this.hostSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property hostSubscriptionId in model HDInsightOnDemandLinkedServiceTypeProperties"));
        }
        if (this.servicePrincipalKey() != null) {
            this.servicePrincipalKey().validate();
        }
        if (this.tenant() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property tenant in model HDInsightOnDemandLinkedServiceTypeProperties"));
        }
        if (this.clusterResourceGroup() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property clusterResourceGroup in model HDInsightOnDemandLinkedServiceTypeProperties"));
        }
        if (this.clusterPassword() != null) {
            this.clusterPassword().validate();
        }
        if (this.clusterSshPassword() != null) {
            this.clusterSshPassword().validate();
        }
        if (this.additionalLinkedServiceNames() != null) {
            this.additionalLinkedServiceNames().forEach(e -> e.validate());
        }
        if (this.hcatalogLinkedServiceName() != null) {
            this.hcatalogLinkedServiceName().validate();
        }
        if (this.scriptActions() != null) {
            this.scriptActions().forEach(e -> e.validate());
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("clusterSize", this.clusterSize);
        jsonWriter.writeUntypedField("timeToLive", this.timeToLive);
        jsonWriter.writeUntypedField("version", this.version);
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName);
        jsonWriter.writeUntypedField("hostSubscriptionId", this.hostSubscriptionId);
        jsonWriter.writeUntypedField("tenant", this.tenant);
        jsonWriter.writeUntypedField("clusterResourceGroup", this.clusterResourceGroup);
        if (this.servicePrincipalId != null) {
            jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        }
        jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
        if (this.clusterNamePrefix != null) {
            jsonWriter.writeUntypedField("clusterNamePrefix", this.clusterNamePrefix);
        }
        if (this.clusterUsername != null) {
            jsonWriter.writeUntypedField("clusterUserName", this.clusterUsername);
        }
        jsonWriter.writeJsonField("clusterPassword", (JsonSerializable)this.clusterPassword);
        if (this.clusterSshUsername != null) {
            jsonWriter.writeUntypedField("clusterSshUserName", this.clusterSshUsername);
        }
        jsonWriter.writeJsonField("clusterSshPassword", (JsonSerializable)this.clusterSshPassword);
        jsonWriter.writeArrayField("additionalLinkedServiceNames", this.additionalLinkedServiceNames, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("hcatalogLinkedServiceName", (JsonSerializable)this.hcatalogLinkedServiceName);
        if (this.clusterType != null) {
            jsonWriter.writeUntypedField("clusterType", this.clusterType);
        }
        if (this.sparkVersion != null) {
            jsonWriter.writeUntypedField("sparkVersion", this.sparkVersion);
        }
        if (this.coreConfiguration != null) {
            jsonWriter.writeUntypedField("coreConfiguration", this.coreConfiguration);
        }
        if (this.hBaseConfiguration != null) {
            jsonWriter.writeUntypedField("hBaseConfiguration", this.hBaseConfiguration);
        }
        if (this.hdfsConfiguration != null) {
            jsonWriter.writeUntypedField("hdfsConfiguration", this.hdfsConfiguration);
        }
        if (this.hiveConfiguration != null) {
            jsonWriter.writeUntypedField("hiveConfiguration", this.hiveConfiguration);
        }
        if (this.mapReduceConfiguration != null) {
            jsonWriter.writeUntypedField("mapReduceConfiguration", this.mapReduceConfiguration);
        }
        if (this.oozieConfiguration != null) {
            jsonWriter.writeUntypedField("oozieConfiguration", this.oozieConfiguration);
        }
        if (this.stormConfiguration != null) {
            jsonWriter.writeUntypedField("stormConfiguration", this.stormConfiguration);
        }
        if (this.yarnConfiguration != null) {
            jsonWriter.writeUntypedField("yarnConfiguration", this.yarnConfiguration);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        if (this.headNodeSize != null) {
            jsonWriter.writeUntypedField("headNodeSize", this.headNodeSize);
        }
        if (this.dataNodeSize != null) {
            jsonWriter.writeUntypedField("dataNodeSize", this.dataNodeSize);
        }
        if (this.zookeeperNodeSize != null) {
            jsonWriter.writeUntypedField("zookeeperNodeSize", this.zookeeperNodeSize);
        }
        jsonWriter.writeArrayField("scriptActions", this.scriptActions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.virtualNetworkId != null) {
            jsonWriter.writeUntypedField("virtualNetworkId", this.virtualNetworkId);
        }
        if (this.subnetName != null) {
            jsonWriter.writeUntypedField("subnetName", this.subnetName);
        }
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        return jsonWriter.writeEndObject();
    }

    public static HDInsightOnDemandLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (HDInsightOnDemandLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            HDInsightOnDemandLinkedServiceTypeProperties deserializedHDInsightOnDemandLinkedServiceTypeProperties = new HDInsightOnDemandLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("clusterSize".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.clusterSize = reader.readUntyped();
                    continue;
                }
                if ("timeToLive".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.timeToLive = reader.readUntyped();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.version = reader.readUntyped();
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.linkedServiceName = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("hostSubscriptionId".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.hostSubscriptionId = reader.readUntyped();
                    continue;
                }
                if ("tenant".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.tenant = reader.readUntyped();
                    continue;
                }
                if ("clusterResourceGroup".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.clusterResourceGroup = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalKey".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.servicePrincipalKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("clusterNamePrefix".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.clusterNamePrefix = reader.readUntyped();
                    continue;
                }
                if ("clusterUserName".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.clusterUsername = reader.readUntyped();
                    continue;
                }
                if ("clusterPassword".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.clusterPassword = SecretBase.fromJson(reader);
                    continue;
                }
                if ("clusterSshUserName".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.clusterSshUsername = reader.readUntyped();
                    continue;
                }
                if ("clusterSshPassword".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.clusterSshPassword = SecretBase.fromJson(reader);
                    continue;
                }
                if ("additionalLinkedServiceNames".equals(fieldName)) {
                    List additionalLinkedServiceNames;
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.additionalLinkedServiceNames = additionalLinkedServiceNames = reader.readArray(reader1 -> LinkedServiceReference.fromJson(reader1));
                    continue;
                }
                if ("hcatalogLinkedServiceName".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.hcatalogLinkedServiceName = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("clusterType".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.clusterType = reader.readUntyped();
                    continue;
                }
                if ("sparkVersion".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.sparkVersion = reader.readUntyped();
                    continue;
                }
                if ("coreConfiguration".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.coreConfiguration = reader.readUntyped();
                    continue;
                }
                if ("hBaseConfiguration".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.hBaseConfiguration = reader.readUntyped();
                    continue;
                }
                if ("hdfsConfiguration".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.hdfsConfiguration = reader.readUntyped();
                    continue;
                }
                if ("hiveConfiguration".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.hiveConfiguration = reader.readUntyped();
                    continue;
                }
                if ("mapReduceConfiguration".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.mapReduceConfiguration = reader.readUntyped();
                    continue;
                }
                if ("oozieConfiguration".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.oozieConfiguration = reader.readUntyped();
                    continue;
                }
                if ("stormConfiguration".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.stormConfiguration = reader.readUntyped();
                    continue;
                }
                if ("yarnConfiguration".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.yarnConfiguration = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("headNodeSize".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.headNodeSize = reader.readUntyped();
                    continue;
                }
                if ("dataNodeSize".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.dataNodeSize = reader.readUntyped();
                    continue;
                }
                if ("zookeeperNodeSize".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.zookeeperNodeSize = reader.readUntyped();
                    continue;
                }
                if ("scriptActions".equals(fieldName)) {
                    List scriptActions;
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.scriptActions = scriptActions = reader.readArray(reader1 -> ScriptAction.fromJson(reader1));
                    continue;
                }
                if ("virtualNetworkId".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.virtualNetworkId = reader.readUntyped();
                    continue;
                }
                if ("subnetName".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.subnetName = reader.readUntyped();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedHDInsightOnDemandLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHDInsightOnDemandLinkedServiceTypeProperties;
        });
    }
}

