/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.FactoryProperties;
import com.azure.resourcemanager.datafactory.models.EncryptionConfiguration;
import com.azure.resourcemanager.datafactory.models.FactoryIdentity;
import com.azure.resourcemanager.datafactory.models.FactoryRepoConfiguration;
import com.azure.resourcemanager.datafactory.models.GlobalParameterSpecification;
import com.azure.resourcemanager.datafactory.models.PublicNetworkAccess;
import com.azure.resourcemanager.datafactory.models.PurviewConfiguration;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

public final class FactoryInner
extends Resource {
    private FactoryIdentity identity;
    private FactoryProperties innerProperties;
    private String etag;
    private Map<String, Object> additionalProperties;
    private String type;
    private String name;
    private String id;

    public FactoryIdentity identity() {
        return this.identity;
    }

    public FactoryInner withIdentity(FactoryIdentity identity) {
        this.identity = identity;
        return this;
    }

    private FactoryProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public FactoryInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public FactoryInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public FactoryInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public OffsetDateTime createTime() {
        return this.innerProperties() == null ? null : this.innerProperties().createTime();
    }

    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public PurviewConfiguration purviewConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().purviewConfiguration();
    }

    public FactoryInner withPurviewConfiguration(PurviewConfiguration purviewConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FactoryProperties();
        }
        this.innerProperties().withPurviewConfiguration(purviewConfiguration);
        return this;
    }

    public FactoryRepoConfiguration repoConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().repoConfiguration();
    }

    public FactoryInner withRepoConfiguration(FactoryRepoConfiguration repoConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FactoryProperties();
        }
        this.innerProperties().withRepoConfiguration(repoConfiguration);
        return this;
    }

    public Map<String, GlobalParameterSpecification> globalParameters() {
        return this.innerProperties() == null ? null : this.innerProperties().globalParameters();
    }

    public FactoryInner withGlobalParameters(Map<String, GlobalParameterSpecification> globalParameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FactoryProperties();
        }
        this.innerProperties().withGlobalParameters(globalParameters);
        return this;
    }

    public EncryptionConfiguration encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public FactoryInner withEncryption(EncryptionConfiguration encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FactoryProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public FactoryInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FactoryProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static FactoryInner fromJson(JsonReader jsonReader) throws IOException {
        return (FactoryInner)((Object)jsonReader.readObject(reader -> {
            FactoryInner deserializedFactoryInner = new FactoryInner();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedFactoryInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedFactoryInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFactoryInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedFactoryInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedFactoryInner.withTags(tags);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedFactoryInner.identity = FactoryIdentity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedFactoryInner.innerProperties = FactoryProperties.fromJson(reader);
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedFactoryInner.etag = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedFactoryInner.additionalProperties = additionalProperties;
            return deserializedFactoryInner;
        }));
    }
}

