/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class DynamicsAXLinkedServiceTypeProperties
implements JsonSerializable<DynamicsAXLinkedServiceTypeProperties> {
    private Object url;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object tenant;
    private Object aadResourceId;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(DynamicsAXLinkedServiceTypeProperties.class);

    public Object url() {
        return this.url;
    }

    public DynamicsAXLinkedServiceTypeProperties withUrl(Object url) {
        this.url = url;
        return this;
    }

    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    public DynamicsAXLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public DynamicsAXLinkedServiceTypeProperties withServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object tenant() {
        return this.tenant;
    }

    public DynamicsAXLinkedServiceTypeProperties withTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object aadResourceId() {
        return this.aadResourceId;
    }

    public DynamicsAXLinkedServiceTypeProperties withAadResourceId(Object aadResourceId) {
        this.aadResourceId = aadResourceId;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public DynamicsAXLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.url() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property url in model DynamicsAXLinkedServiceTypeProperties"));
        }
        if (this.servicePrincipalId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property servicePrincipalId in model DynamicsAXLinkedServiceTypeProperties"));
        }
        if (this.servicePrincipalKey() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property servicePrincipalKey in model DynamicsAXLinkedServiceTypeProperties"));
        }
        this.servicePrincipalKey().validate();
        if (this.tenant() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property tenant in model DynamicsAXLinkedServiceTypeProperties"));
        }
        if (this.aadResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property aadResourceId in model DynamicsAXLinkedServiceTypeProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("url", this.url);
        jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
        jsonWriter.writeUntypedField("tenant", this.tenant);
        jsonWriter.writeUntypedField("aadResourceId", this.aadResourceId);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static DynamicsAXLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DynamicsAXLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            DynamicsAXLinkedServiceTypeProperties deserializedDynamicsAXLinkedServiceTypeProperties = new DynamicsAXLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedDynamicsAXLinkedServiceTypeProperties.url = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedDynamicsAXLinkedServiceTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalKey".equals(fieldName)) {
                    deserializedDynamicsAXLinkedServiceTypeProperties.servicePrincipalKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("tenant".equals(fieldName)) {
                    deserializedDynamicsAXLinkedServiceTypeProperties.tenant = reader.readUntyped();
                    continue;
                }
                if ("aadResourceId".equals(fieldName)) {
                    deserializedDynamicsAXLinkedServiceTypeProperties.aadResourceId = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedDynamicsAXLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDynamicsAXLinkedServiceTypeProperties;
        });
    }
}

