/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.Db2AuthenticationType;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class Db2LinkedServiceTypeProperties
implements JsonSerializable<Db2LinkedServiceTypeProperties> {
    private Object connectionString;
    private Object server;
    private Object database;
    private Db2AuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private Object packageCollection;
    private Object certificateCommonName;
    private String encryptedCredential;

    public Object connectionString() {
        return this.connectionString;
    }

    public Db2LinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public Object server() {
        return this.server;
    }

    public Db2LinkedServiceTypeProperties withServer(Object server) {
        this.server = server;
        return this;
    }

    public Object database() {
        return this.database;
    }

    public Db2LinkedServiceTypeProperties withDatabase(Object database) {
        this.database = database;
        return this;
    }

    public Db2AuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public Db2LinkedServiceTypeProperties withAuthenticationType(Db2AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public Db2LinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public Db2LinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object packageCollection() {
        return this.packageCollection;
    }

    public Db2LinkedServiceTypeProperties withPackageCollection(Object packageCollection) {
        this.packageCollection = packageCollection;
        return this;
    }

    public Object certificateCommonName() {
        return this.certificateCommonName;
    }

    public Db2LinkedServiceTypeProperties withCertificateCommonName(Object certificateCommonName) {
        this.certificateCommonName = certificateCommonName;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public Db2LinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.connectionString != null) {
            jsonWriter.writeUntypedField("connectionString", this.connectionString);
        }
        if (this.server != null) {
            jsonWriter.writeUntypedField("server", this.server);
        }
        if (this.database != null) {
            jsonWriter.writeUntypedField("database", this.database);
        }
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        if (this.username != null) {
            jsonWriter.writeUntypedField("username", this.username);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        if (this.packageCollection != null) {
            jsonWriter.writeUntypedField("packageCollection", this.packageCollection);
        }
        if (this.certificateCommonName != null) {
            jsonWriter.writeUntypedField("certificateCommonName", this.certificateCommonName);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static Db2LinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (Db2LinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            Db2LinkedServiceTypeProperties deserializedDb2LinkedServiceTypeProperties = new Db2LinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionString".equals(fieldName)) {
                    deserializedDb2LinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("server".equals(fieldName)) {
                    deserializedDb2LinkedServiceTypeProperties.server = reader.readUntyped();
                    continue;
                }
                if ("database".equals(fieldName)) {
                    deserializedDb2LinkedServiceTypeProperties.database = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedDb2LinkedServiceTypeProperties.authenticationType = Db2AuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedDb2LinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedDb2LinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("packageCollection".equals(fieldName)) {
                    deserializedDb2LinkedServiceTypeProperties.packageCollection = reader.readUntyped();
                    continue;
                }
                if ("certificateCommonName".equals(fieldName)) {
                    deserializedDb2LinkedServiceTypeProperties.certificateCommonName = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedDb2LinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDb2LinkedServiceTypeProperties;
        });
    }
}

