/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DataFlow;
import java.io.IOException;

public final class DataFlowResourceInner
extends SubResource {
    private DataFlow properties;
    private String name;
    private String type;
    private String etag;
    private static final ClientLogger LOGGER = new ClientLogger(DataFlowResourceInner.class);

    public DataFlow properties() {
        return this.properties;
    }

    public DataFlowResourceInner withProperties(DataFlow properties) {
        this.properties = properties;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String etag() {
        return this.etag;
    }

    public DataFlowResourceInner withId(String id) {
        super.withId(id);
        return this;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model DataFlowResourceInner"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static DataFlowResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (DataFlowResourceInner)((Object)jsonReader.readObject(reader -> {
            DataFlowResourceInner deserializedDataFlowResourceInner = new DataFlowResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDataFlowResourceInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDataFlowResourceInner.properties = DataFlow.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDataFlowResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDataFlowResourceInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedDataFlowResourceInner.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataFlowResourceInner;
        }));
    }
}

