/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class CmdkeySetupTypeProperties
implements JsonSerializable<CmdkeySetupTypeProperties> {
    private Object targetName;
    private Object username;
    private SecretBase password;
    private static final ClientLogger LOGGER = new ClientLogger(CmdkeySetupTypeProperties.class);

    public Object targetName() {
        return this.targetName;
    }

    public CmdkeySetupTypeProperties withTargetName(Object targetName) {
        this.targetName = targetName;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public CmdkeySetupTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public CmdkeySetupTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public void validate() {
        if (this.targetName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetName in model CmdkeySetupTypeProperties"));
        }
        if (this.username() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property username in model CmdkeySetupTypeProperties"));
        }
        if (this.password() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property password in model CmdkeySetupTypeProperties"));
        }
        this.password().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("targetName", this.targetName);
        jsonWriter.writeUntypedField("userName", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        return jsonWriter.writeEndObject();
    }

    public static CmdkeySetupTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CmdkeySetupTypeProperties)jsonReader.readObject(reader -> {
            CmdkeySetupTypeProperties deserializedCmdkeySetupTypeProperties = new CmdkeySetupTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetName".equals(fieldName)) {
                    deserializedCmdkeySetupTypeProperties.targetName = reader.readUntyped();
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedCmdkeySetupTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedCmdkeySetupTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCmdkeySetupTypeProperties;
        });
    }
}

