/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.AzureStorageLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import java.io.IOException;

public final class AzureTableStorageLinkedServiceTypeProperties
extends AzureStorageLinkedServiceTypeProperties {
    private Object serviceEndpoint;
    private CredentialReference credential;

    public Object serviceEndpoint() {
        return this.serviceEndpoint;
    }

    public AzureTableStorageLinkedServiceTypeProperties withServiceEndpoint(Object serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public AzureTableStorageLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public AzureTableStorageLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        super.withConnectionString(connectionString);
        return this;
    }

    @Override
    public AzureTableStorageLinkedServiceTypeProperties withAccountKey(AzureKeyVaultSecretReference accountKey) {
        super.withAccountKey(accountKey);
        return this;
    }

    @Override
    public AzureTableStorageLinkedServiceTypeProperties withSasUri(Object sasUri) {
        super.withSasUri(sasUri);
        return this;
    }

    @Override
    public AzureTableStorageLinkedServiceTypeProperties withSasToken(AzureKeyVaultSecretReference sasToken) {
        super.withSasToken(sasToken);
        return this;
    }

    @Override
    public AzureTableStorageLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        super.withEncryptedCredential(encryptedCredential);
        return this;
    }

    @Override
    public void validate() {
        if (this.credential() != null) {
            this.credential().validate();
        }
        if (this.accountKey() != null) {
            this.accountKey().validate();
        }
        if (this.sasToken() != null) {
            this.sasToken().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.connectionString() != null) {
            jsonWriter.writeUntypedField("connectionString", this.connectionString());
        }
        jsonWriter.writeJsonField("accountKey", (JsonSerializable)this.accountKey());
        if (this.sasUri() != null) {
            jsonWriter.writeUntypedField("sasUri", this.sasUri());
        }
        jsonWriter.writeJsonField("sasToken", (JsonSerializable)this.sasToken());
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential());
        if (this.serviceEndpoint != null) {
            jsonWriter.writeUntypedField("serviceEndpoint", this.serviceEndpoint);
        }
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        return jsonWriter.writeEndObject();
    }

    public static AzureTableStorageLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureTableStorageLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AzureTableStorageLinkedServiceTypeProperties deserializedAzureTableStorageLinkedServiceTypeProperties = new AzureTableStorageLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionString".equals(fieldName)) {
                    deserializedAzureTableStorageLinkedServiceTypeProperties.withConnectionString(reader.readUntyped());
                    continue;
                }
                if ("accountKey".equals(fieldName)) {
                    deserializedAzureTableStorageLinkedServiceTypeProperties.withAccountKey(AzureKeyVaultSecretReference.fromJson(reader));
                    continue;
                }
                if ("sasUri".equals(fieldName)) {
                    deserializedAzureTableStorageLinkedServiceTypeProperties.withSasUri(reader.readUntyped());
                    continue;
                }
                if ("sasToken".equals(fieldName)) {
                    deserializedAzureTableStorageLinkedServiceTypeProperties.withSasToken(AzureKeyVaultSecretReference.fromJson(reader));
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAzureTableStorageLinkedServiceTypeProperties.withEncryptedCredential(reader.getString());
                    continue;
                }
                if ("serviceEndpoint".equals(fieldName)) {
                    deserializedAzureTableStorageLinkedServiceTypeProperties.serviceEndpoint = reader.readUntyped();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedAzureTableStorageLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureTableStorageLinkedServiceTypeProperties;
        });
    }
}

