/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;
import java.util.Map;

public final class AzureDatabricksLinkedServiceTypeProperties
implements JsonSerializable<AzureDatabricksLinkedServiceTypeProperties> {
    private Object domain;
    private SecretBase accessToken;
    private Object authentication;
    private Object workspaceResourceId;
    private Object existingClusterId;
    private Object instancePoolId;
    private Object newClusterVersion;
    private Object newClusterNumOfWorker;
    private Object newClusterNodeType;
    private Map<String, Object> newClusterSparkConf;
    private Map<String, Object> newClusterSparkEnvVars;
    private Map<String, Object> newClusterCustomTags;
    private Object newClusterLogDestination;
    private Object newClusterDriverNodeType;
    private Object newClusterInitScripts;
    private Object newClusterEnableElasticDisk;
    private String encryptedCredential;
    private Object policyId;
    private CredentialReference credential;
    private Object dataSecurityMode;
    private static final ClientLogger LOGGER = new ClientLogger(AzureDatabricksLinkedServiceTypeProperties.class);

    public Object domain() {
        return this.domain;
    }

    public AzureDatabricksLinkedServiceTypeProperties withDomain(Object domain) {
        this.domain = domain;
        return this;
    }

    public SecretBase accessToken() {
        return this.accessToken;
    }

    public AzureDatabricksLinkedServiceTypeProperties withAccessToken(SecretBase accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public Object authentication() {
        return this.authentication;
    }

    public AzureDatabricksLinkedServiceTypeProperties withAuthentication(Object authentication) {
        this.authentication = authentication;
        return this;
    }

    public Object workspaceResourceId() {
        return this.workspaceResourceId;
    }

    public AzureDatabricksLinkedServiceTypeProperties withWorkspaceResourceId(Object workspaceResourceId) {
        this.workspaceResourceId = workspaceResourceId;
        return this;
    }

    public Object existingClusterId() {
        return this.existingClusterId;
    }

    public AzureDatabricksLinkedServiceTypeProperties withExistingClusterId(Object existingClusterId) {
        this.existingClusterId = existingClusterId;
        return this;
    }

    public Object instancePoolId() {
        return this.instancePoolId;
    }

    public AzureDatabricksLinkedServiceTypeProperties withInstancePoolId(Object instancePoolId) {
        this.instancePoolId = instancePoolId;
        return this;
    }

    public Object newClusterVersion() {
        return this.newClusterVersion;
    }

    public AzureDatabricksLinkedServiceTypeProperties withNewClusterVersion(Object newClusterVersion) {
        this.newClusterVersion = newClusterVersion;
        return this;
    }

    public Object newClusterNumOfWorker() {
        return this.newClusterNumOfWorker;
    }

    public AzureDatabricksLinkedServiceTypeProperties withNewClusterNumOfWorker(Object newClusterNumOfWorker) {
        this.newClusterNumOfWorker = newClusterNumOfWorker;
        return this;
    }

    public Object newClusterNodeType() {
        return this.newClusterNodeType;
    }

    public AzureDatabricksLinkedServiceTypeProperties withNewClusterNodeType(Object newClusterNodeType) {
        this.newClusterNodeType = newClusterNodeType;
        return this;
    }

    public Map<String, Object> newClusterSparkConf() {
        return this.newClusterSparkConf;
    }

    public AzureDatabricksLinkedServiceTypeProperties withNewClusterSparkConf(Map<String, Object> newClusterSparkConf) {
        this.newClusterSparkConf = newClusterSparkConf;
        return this;
    }

    public Map<String, Object> newClusterSparkEnvVars() {
        return this.newClusterSparkEnvVars;
    }

    public AzureDatabricksLinkedServiceTypeProperties withNewClusterSparkEnvVars(Map<String, Object> newClusterSparkEnvVars) {
        this.newClusterSparkEnvVars = newClusterSparkEnvVars;
        return this;
    }

    public Map<String, Object> newClusterCustomTags() {
        return this.newClusterCustomTags;
    }

    public AzureDatabricksLinkedServiceTypeProperties withNewClusterCustomTags(Map<String, Object> newClusterCustomTags) {
        this.newClusterCustomTags = newClusterCustomTags;
        return this;
    }

    public Object newClusterLogDestination() {
        return this.newClusterLogDestination;
    }

    public AzureDatabricksLinkedServiceTypeProperties withNewClusterLogDestination(Object newClusterLogDestination) {
        this.newClusterLogDestination = newClusterLogDestination;
        return this;
    }

    public Object newClusterDriverNodeType() {
        return this.newClusterDriverNodeType;
    }

    public AzureDatabricksLinkedServiceTypeProperties withNewClusterDriverNodeType(Object newClusterDriverNodeType) {
        this.newClusterDriverNodeType = newClusterDriverNodeType;
        return this;
    }

    public Object newClusterInitScripts() {
        return this.newClusterInitScripts;
    }

    public AzureDatabricksLinkedServiceTypeProperties withNewClusterInitScripts(Object newClusterInitScripts) {
        this.newClusterInitScripts = newClusterInitScripts;
        return this;
    }

    public Object newClusterEnableElasticDisk() {
        return this.newClusterEnableElasticDisk;
    }

    public AzureDatabricksLinkedServiceTypeProperties withNewClusterEnableElasticDisk(Object newClusterEnableElasticDisk) {
        this.newClusterEnableElasticDisk = newClusterEnableElasticDisk;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureDatabricksLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public Object policyId() {
        return this.policyId;
    }

    public AzureDatabricksLinkedServiceTypeProperties withPolicyId(Object policyId) {
        this.policyId = policyId;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public AzureDatabricksLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public Object dataSecurityMode() {
        return this.dataSecurityMode;
    }

    public AzureDatabricksLinkedServiceTypeProperties withDataSecurityMode(Object dataSecurityMode) {
        this.dataSecurityMode = dataSecurityMode;
        return this;
    }

    public void validate() {
        if (this.domain() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property domain in model AzureDatabricksLinkedServiceTypeProperties"));
        }
        if (this.accessToken() != null) {
            this.accessToken().validate();
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("domain", this.domain);
        jsonWriter.writeJsonField("accessToken", (JsonSerializable)this.accessToken);
        if (this.authentication != null) {
            jsonWriter.writeUntypedField("authentication", this.authentication);
        }
        if (this.workspaceResourceId != null) {
            jsonWriter.writeUntypedField("workspaceResourceId", this.workspaceResourceId);
        }
        if (this.existingClusterId != null) {
            jsonWriter.writeUntypedField("existingClusterId", this.existingClusterId);
        }
        if (this.instancePoolId != null) {
            jsonWriter.writeUntypedField("instancePoolId", this.instancePoolId);
        }
        if (this.newClusterVersion != null) {
            jsonWriter.writeUntypedField("newClusterVersion", this.newClusterVersion);
        }
        if (this.newClusterNumOfWorker != null) {
            jsonWriter.writeUntypedField("newClusterNumOfWorker", this.newClusterNumOfWorker);
        }
        if (this.newClusterNodeType != null) {
            jsonWriter.writeUntypedField("newClusterNodeType", this.newClusterNodeType);
        }
        jsonWriter.writeMapField("newClusterSparkConf", this.newClusterSparkConf, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeMapField("newClusterSparkEnvVars", this.newClusterSparkEnvVars, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeMapField("newClusterCustomTags", this.newClusterCustomTags, (writer, element) -> writer.writeUntyped(element));
        if (this.newClusterLogDestination != null) {
            jsonWriter.writeUntypedField("newClusterLogDestination", this.newClusterLogDestination);
        }
        if (this.newClusterDriverNodeType != null) {
            jsonWriter.writeUntypedField("newClusterDriverNodeType", this.newClusterDriverNodeType);
        }
        if (this.newClusterInitScripts != null) {
            jsonWriter.writeUntypedField("newClusterInitScripts", this.newClusterInitScripts);
        }
        if (this.newClusterEnableElasticDisk != null) {
            jsonWriter.writeUntypedField("newClusterEnableElasticDisk", this.newClusterEnableElasticDisk);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        if (this.policyId != null) {
            jsonWriter.writeUntypedField("policyId", this.policyId);
        }
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        if (this.dataSecurityMode != null) {
            jsonWriter.writeUntypedField("dataSecurityMode", this.dataSecurityMode);
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureDatabricksLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDatabricksLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AzureDatabricksLinkedServiceTypeProperties deserializedAzureDatabricksLinkedServiceTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("domain".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedServiceTypeProperties.domain = reader.readUntyped();
                    continue;
                }
                if ("accessToken".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedServiceTypeProperties.accessToken = SecretBase.fromJson(reader);
                    continue;
                }
                if ("authentication".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedServiceTypeProperties.authentication = reader.readUntyped();
                    continue;
                }
                if ("workspaceResourceId".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedServiceTypeProperties.workspaceResourceId = reader.readUntyped();
                    continue;
                }
                if ("existingClusterId".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedServiceTypeProperties.existingClusterId = reader.readUntyped();
                    continue;
                }
                if ("instancePoolId".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedServiceTypeProperties.instancePoolId = reader.readUntyped();
                    continue;
                }
                if ("newClusterVersion".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedServiceTypeProperties.newClusterVersion = reader.readUntyped();
                    continue;
                }
                if ("newClusterNumOfWorker".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedServiceTypeProperties.newClusterNumOfWorker = reader.readUntyped();
                    continue;
                }
                if ("newClusterNodeType".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedServiceTypeProperties.newClusterNodeType = reader.readUntyped();
                    continue;
                }
                if ("newClusterSparkConf".equals(fieldName)) {
                    Map newClusterSparkConf;
                    deserializedAzureDatabricksLinkedServiceTypeProperties.newClusterSparkConf = newClusterSparkConf = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("newClusterSparkEnvVars".equals(fieldName)) {
                    Map newClusterSparkEnvVars;
                    deserializedAzureDatabricksLinkedServiceTypeProperties.newClusterSparkEnvVars = newClusterSparkEnvVars = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("newClusterCustomTags".equals(fieldName)) {
                    Map newClusterCustomTags;
                    deserializedAzureDatabricksLinkedServiceTypeProperties.newClusterCustomTags = newClusterCustomTags = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("newClusterLogDestination".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedServiceTypeProperties.newClusterLogDestination = reader.readUntyped();
                    continue;
                }
                if ("newClusterDriverNodeType".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedServiceTypeProperties.newClusterDriverNodeType = reader.readUntyped();
                    continue;
                }
                if ("newClusterInitScripts".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedServiceTypeProperties.newClusterInitScripts = reader.readUntyped();
                    continue;
                }
                if ("newClusterEnableElasticDisk".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedServiceTypeProperties.newClusterEnableElasticDisk = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("policyId".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedServiceTypeProperties.policyId = reader.readUntyped();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                if ("dataSecurityMode".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedServiceTypeProperties.dataSecurityMode = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureDatabricksLinkedServiceTypeProperties;
        });
    }
}

