/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.ActivityRun;
import java.io.IOException;
import java.util.List;

public final class ActivityRunsQueryResponseInner
implements JsonSerializable<ActivityRunsQueryResponseInner> {
    private List<ActivityRun> value;
    private String continuationToken;
    private static final ClientLogger LOGGER = new ClientLogger(ActivityRunsQueryResponseInner.class);

    public List<ActivityRun> value() {
        return this.value;
    }

    public ActivityRunsQueryResponseInner withValue(List<ActivityRun> value) {
        this.value = value;
        return this;
    }

    public String continuationToken() {
        return this.continuationToken;
    }

    public ActivityRunsQueryResponseInner withContinuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ActivityRunsQueryResponseInner"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("continuationToken", this.continuationToken);
        return jsonWriter.writeEndObject();
    }

    public static ActivityRunsQueryResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return (ActivityRunsQueryResponseInner)jsonReader.readObject(reader -> {
            ActivityRunsQueryResponseInner deserializedActivityRunsQueryResponseInner = new ActivityRunsQueryResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedActivityRunsQueryResponseInner.value = value = reader.readArray(reader1 -> ActivityRun.fromJson(reader1));
                    continue;
                }
                if ("continuationToken".equals(fieldName)) {
                    deserializedActivityRunsQueryResponseInner.continuationToken = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedActivityRunsQueryResponseInner;
        });
    }
}

