/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.TriggerDependencyReference;
import com.azure.resourcemanager.datafactory.models.TriggerReference;
import java.io.IOException;

public final class TumblingWindowTriggerDependencyReference
extends TriggerDependencyReference {
    private String type = "TumblingWindowTriggerDependencyReference";
    private String offset;
    private String size;
    private static final ClientLogger LOGGER = new ClientLogger(TumblingWindowTriggerDependencyReference.class);

    @Override
    public String type() {
        return this.type;
    }

    public String offset() {
        return this.offset;
    }

    public TumblingWindowTriggerDependencyReference withOffset(String offset) {
        this.offset = offset;
        return this;
    }

    public String size() {
        return this.size;
    }

    public TumblingWindowTriggerDependencyReference withSize(String size) {
        this.size = size;
        return this;
    }

    @Override
    public TumblingWindowTriggerDependencyReference withReferenceTrigger(TriggerReference referenceTrigger) {
        super.withReferenceTrigger(referenceTrigger);
        return this;
    }

    @Override
    public void validate() {
        if (this.referenceTrigger() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property referenceTrigger in model TumblingWindowTriggerDependencyReference"));
        }
        this.referenceTrigger().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("referenceTrigger", (JsonSerializable)this.referenceTrigger());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("offset", this.offset);
        jsonWriter.writeStringField("size", this.size);
        return jsonWriter.writeEndObject();
    }

    public static TumblingWindowTriggerDependencyReference fromJson(JsonReader jsonReader) throws IOException {
        return (TumblingWindowTriggerDependencyReference)jsonReader.readObject(reader -> {
            TumblingWindowTriggerDependencyReference deserializedTumblingWindowTriggerDependencyReference = new TumblingWindowTriggerDependencyReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("referenceTrigger".equals(fieldName)) {
                    deserializedTumblingWindowTriggerDependencyReference.withReferenceTrigger(TriggerReference.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTumblingWindowTriggerDependencyReference.type = reader.getString();
                    continue;
                }
                if ("offset".equals(fieldName)) {
                    deserializedTumblingWindowTriggerDependencyReference.offset = reader.getString();
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedTumblingWindowTriggerDependencyReference.size = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTumblingWindowTriggerDependencyReference;
        });
    }
}

