/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.TriggerReferenceType;
import java.io.IOException;

public final class TriggerReference
implements JsonSerializable<TriggerReference> {
    private TriggerReferenceType type;
    private String referenceName;
    private static final ClientLogger LOGGER = new ClientLogger(TriggerReference.class);

    public TriggerReferenceType type() {
        return this.type;
    }

    public TriggerReference withType(TriggerReferenceType type) {
        this.type = type;
        return this;
    }

    public String referenceName() {
        return this.referenceName;
    }

    public TriggerReference withReferenceName(String referenceName) {
        this.referenceName = referenceName;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model TriggerReference"));
        }
        if (this.referenceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property referenceName in model TriggerReference"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("referenceName", this.referenceName);
        return jsonWriter.writeEndObject();
    }

    public static TriggerReference fromJson(JsonReader jsonReader) throws IOException {
        return (TriggerReference)jsonReader.readObject(reader -> {
            TriggerReference deserializedTriggerReference = new TriggerReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedTriggerReference.type = TriggerReferenceType.fromString(reader.getString());
                    continue;
                }
                if ("referenceName".equals(fieldName)) {
                    deserializedTriggerReference.referenceName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTriggerReference;
        });
    }
}

