/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.TabularSource;
import com.azure.resourcemanager.datafactory.models.TeradataPartitionSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class TeradataSource
extends TabularSource {
    private String type = "TeradataSource";
    private Object query;
    private Object partitionOption;
    private TeradataPartitionSettings partitionSettings;

    @Override
    public String type() {
        return this.type;
    }

    public Object query() {
        return this.query;
    }

    public TeradataSource withQuery(Object query) {
        this.query = query;
        return this;
    }

    public Object partitionOption() {
        return this.partitionOption;
    }

    public TeradataSource withPartitionOption(Object partitionOption) {
        this.partitionOption = partitionOption;
        return this;
    }

    public TeradataPartitionSettings partitionSettings() {
        return this.partitionSettings;
    }

    public TeradataSource withPartitionSettings(TeradataPartitionSettings partitionSettings) {
        this.partitionSettings = partitionSettings;
        return this;
    }

    @Override
    public TeradataSource withQueryTimeout(Object queryTimeout) {
        super.withQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public TeradataSource withAdditionalColumns(Object additionalColumns) {
        super.withAdditionalColumns(additionalColumns);
        return this;
    }

    @Override
    public TeradataSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public TeradataSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public TeradataSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public TeradataSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.partitionSettings() != null) {
            this.partitionSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeUntypedField("queryTimeout", this.queryTimeout());
        jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("query", this.query);
        jsonWriter.writeUntypedField("partitionOption", this.partitionOption);
        jsonWriter.writeJsonField("partitionSettings", (JsonSerializable)this.partitionSettings);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static TeradataSource fromJson(JsonReader jsonReader) throws IOException {
        return (TeradataSource)jsonReader.readObject(reader -> {
            TeradataSource deserializedTeradataSource = new TeradataSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedTeradataSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedTeradataSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedTeradataSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedTeradataSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedTeradataSource.withQueryTimeout(reader.readUntyped());
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedTeradataSource.withAdditionalColumns(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTeradataSource.type = reader.getString();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedTeradataSource.query = reader.readUntyped();
                    continue;
                }
                if ("partitionOption".equals(fieldName)) {
                    deserializedTeradataSource.partitionOption = reader.readUntyped();
                    continue;
                }
                if ("partitionSettings".equals(fieldName)) {
                    deserializedTeradataSource.partitionSettings = TeradataPartitionSettings.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedTeradataSource.withAdditionalProperties(additionalProperties);
            return deserializedTeradataSource;
        });
    }
}

