/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.SwitchActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.Activity;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.ControlActivity;
import com.azure.resourcemanager.datafactory.models.Expression;
import com.azure.resourcemanager.datafactory.models.SwitchCase;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SwitchActivity
extends ControlActivity {
    private String type = "Switch";
    private SwitchActivityTypeProperties innerTypeProperties = new SwitchActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SwitchActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    SwitchActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public SwitchActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public SwitchActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public SwitchActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public SwitchActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public SwitchActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public SwitchActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public Expression on() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().on();
    }

    public SwitchActivity withOn(Expression on) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SwitchActivityTypeProperties();
        }
        this.innerTypeProperties().withOn(on);
        return this;
    }

    public List<SwitchCase> cases() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().cases();
    }

    public SwitchActivity withCases(List<SwitchCase> cases) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SwitchActivityTypeProperties();
        }
        this.innerTypeProperties().withCases(cases);
        return this;
    }

    public List<Activity> defaultActivities() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().defaultActivities();
    }

    public SwitchActivity withDefaultActivities(List<Activity> defaultActivities) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SwitchActivityTypeProperties();
        }
        this.innerTypeProperties().withDefaultActivities(defaultActivities);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model SwitchActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model SwitchActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SwitchActivity fromJson(JsonReader jsonReader) throws IOException {
        return (SwitchActivity)jsonReader.readObject(reader -> {
            SwitchActivity deserializedSwitchActivity = new SwitchActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSwitchActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSwitchActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSwitchActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedSwitchActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedSwitchActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedSwitchActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedSwitchActivity.innerTypeProperties = SwitchActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSwitchActivity.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSwitchActivity.withAdditionalProperties(additionalProperties);
            return deserializedSwitchActivity;
        });
    }
}

