/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.SsisPackageLocationTypeProperties;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.SsisAccessCredential;
import com.azure.resourcemanager.datafactory.models.SsisChildPackage;
import com.azure.resourcemanager.datafactory.models.SsisPackageLocationType;
import java.io.IOException;
import java.util.List;

public final class SsisPackageLocation
implements JsonSerializable<SsisPackageLocation> {
    private Object packagePath;
    private SsisPackageLocationType type;
    private SsisPackageLocationTypeProperties innerTypeProperties;

    public Object packagePath() {
        return this.packagePath;
    }

    public SsisPackageLocation withPackagePath(Object packagePath) {
        this.packagePath = packagePath;
        return this;
    }

    public SsisPackageLocationType type() {
        return this.type;
    }

    public SsisPackageLocation withType(SsisPackageLocationType type) {
        this.type = type;
        return this;
    }

    private SsisPackageLocationTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    public SecretBase packagePassword() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().packagePassword();
    }

    public SsisPackageLocation withPackagePassword(SecretBase packagePassword) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SsisPackageLocationTypeProperties();
        }
        this.innerTypeProperties().withPackagePassword(packagePassword);
        return this;
    }

    public SsisAccessCredential accessCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().accessCredential();
    }

    public SsisPackageLocation withAccessCredential(SsisAccessCredential accessCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SsisPackageLocationTypeProperties();
        }
        this.innerTypeProperties().withAccessCredential(accessCredential);
        return this;
    }

    public Object configurationPath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().configurationPath();
    }

    public SsisPackageLocation withConfigurationPath(Object configurationPath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SsisPackageLocationTypeProperties();
        }
        this.innerTypeProperties().withConfigurationPath(configurationPath);
        return this;
    }

    public SsisAccessCredential configurationAccessCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().configurationAccessCredential();
    }

    public SsisPackageLocation withConfigurationAccessCredential(SsisAccessCredential configurationAccessCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SsisPackageLocationTypeProperties();
        }
        this.innerTypeProperties().withConfigurationAccessCredential(configurationAccessCredential);
        return this;
    }

    public String packageName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().packageName();
    }

    public SsisPackageLocation withPackageName(String packageName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SsisPackageLocationTypeProperties();
        }
        this.innerTypeProperties().withPackageName(packageName);
        return this;
    }

    public Object packageContent() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().packageContent();
    }

    public SsisPackageLocation withPackageContent(Object packageContent) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SsisPackageLocationTypeProperties();
        }
        this.innerTypeProperties().withPackageContent(packageContent);
        return this;
    }

    public String packageLastModifiedDate() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().packageLastModifiedDate();
    }

    public SsisPackageLocation withPackageLastModifiedDate(String packageLastModifiedDate) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SsisPackageLocationTypeProperties();
        }
        this.innerTypeProperties().withPackageLastModifiedDate(packageLastModifiedDate);
        return this;
    }

    public List<SsisChildPackage> childPackages() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().childPackages();
    }

    public SsisPackageLocation withChildPackages(List<SsisChildPackage> childPackages) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SsisPackageLocationTypeProperties();
        }
        this.innerTypeProperties().withChildPackages(childPackages);
        return this;
    }

    public void validate() {
        if (this.innerTypeProperties() != null) {
            this.innerTypeProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("packagePath", this.packagePath);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        return jsonWriter.writeEndObject();
    }

    public static SsisPackageLocation fromJson(JsonReader jsonReader) throws IOException {
        return (SsisPackageLocation)jsonReader.readObject(reader -> {
            SsisPackageLocation deserializedSsisPackageLocation = new SsisPackageLocation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("packagePath".equals(fieldName)) {
                    deserializedSsisPackageLocation.packagePath = reader.readUntyped();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSsisPackageLocation.type = SsisPackageLocationType.fromString(reader.getString());
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedSsisPackageLocation.innerTypeProperties = SsisPackageLocationTypeProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSsisPackageLocation;
        });
    }
}

