/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SqlPartitionSettings;
import com.azure.resourcemanager.datafactory.models.TabularSource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SqlSource
extends TabularSource {
    private String type = "SqlSource";
    private Object sqlReaderQuery;
    private Object sqlReaderStoredProcedureName;
    private Object storedProcedureParameters;
    private Object isolationLevel;
    private Object partitionOption;
    private SqlPartitionSettings partitionSettings;

    @Override
    public String type() {
        return this.type;
    }

    public Object sqlReaderQuery() {
        return this.sqlReaderQuery;
    }

    public SqlSource withSqlReaderQuery(Object sqlReaderQuery) {
        this.sqlReaderQuery = sqlReaderQuery;
        return this;
    }

    public Object sqlReaderStoredProcedureName() {
        return this.sqlReaderStoredProcedureName;
    }

    public SqlSource withSqlReaderStoredProcedureName(Object sqlReaderStoredProcedureName) {
        this.sqlReaderStoredProcedureName = sqlReaderStoredProcedureName;
        return this;
    }

    public Object storedProcedureParameters() {
        return this.storedProcedureParameters;
    }

    public SqlSource withStoredProcedureParameters(Object storedProcedureParameters) {
        this.storedProcedureParameters = storedProcedureParameters;
        return this;
    }

    public Object isolationLevel() {
        return this.isolationLevel;
    }

    public SqlSource withIsolationLevel(Object isolationLevel) {
        this.isolationLevel = isolationLevel;
        return this;
    }

    public Object partitionOption() {
        return this.partitionOption;
    }

    public SqlSource withPartitionOption(Object partitionOption) {
        this.partitionOption = partitionOption;
        return this;
    }

    public SqlPartitionSettings partitionSettings() {
        return this.partitionSettings;
    }

    public SqlSource withPartitionSettings(SqlPartitionSettings partitionSettings) {
        this.partitionSettings = partitionSettings;
        return this;
    }

    @Override
    public SqlSource withQueryTimeout(Object queryTimeout) {
        super.withQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public SqlSource withAdditionalColumns(Object additionalColumns) {
        super.withAdditionalColumns(additionalColumns);
        return this;
    }

    @Override
    public SqlSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public SqlSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public SqlSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public SqlSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.partitionSettings() != null) {
            this.partitionSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeUntypedField("queryTimeout", this.queryTimeout());
        jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("sqlReaderQuery", this.sqlReaderQuery);
        jsonWriter.writeUntypedField("sqlReaderStoredProcedureName", this.sqlReaderStoredProcedureName);
        jsonWriter.writeUntypedField("storedProcedureParameters", this.storedProcedureParameters);
        jsonWriter.writeUntypedField("isolationLevel", this.isolationLevel);
        jsonWriter.writeUntypedField("partitionOption", this.partitionOption);
        jsonWriter.writeJsonField("partitionSettings", (JsonSerializable)this.partitionSettings);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SqlSource fromJson(JsonReader jsonReader) throws IOException {
        return (SqlSource)jsonReader.readObject(reader -> {
            SqlSource deserializedSqlSource = new SqlSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedSqlSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedSqlSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSqlSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedSqlSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedSqlSource.withQueryTimeout(reader.readUntyped());
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedSqlSource.withAdditionalColumns(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSqlSource.type = reader.getString();
                    continue;
                }
                if ("sqlReaderQuery".equals(fieldName)) {
                    deserializedSqlSource.sqlReaderQuery = reader.readUntyped();
                    continue;
                }
                if ("sqlReaderStoredProcedureName".equals(fieldName)) {
                    deserializedSqlSource.sqlReaderStoredProcedureName = reader.readUntyped();
                    continue;
                }
                if ("storedProcedureParameters".equals(fieldName)) {
                    deserializedSqlSource.storedProcedureParameters = reader.readUntyped();
                    continue;
                }
                if ("isolationLevel".equals(fieldName)) {
                    deserializedSqlSource.isolationLevel = reader.readUntyped();
                    continue;
                }
                if ("partitionOption".equals(fieldName)) {
                    deserializedSqlSource.partitionOption = reader.readUntyped();
                    continue;
                }
                if ("partitionSettings".equals(fieldName)) {
                    deserializedSqlSource.partitionSettings = SqlPartitionSettings.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSqlSource.withAdditionalProperties(additionalProperties);
            return deserializedSqlSource;
        });
    }
}

