/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySink;
import com.azure.resourcemanager.datafactory.models.SqlUpsertSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SqlServerSink
extends CopySink {
    private String type = "SqlServerSink";
    private Object sqlWriterStoredProcedureName;
    private Object sqlWriterTableType;
    private Object preCopyScript;
    private Object storedProcedureParameters;
    private Object storedProcedureTableTypeParameterName;
    private Object tableOption;
    private Object sqlWriterUseTableLock;
    private Object writeBehavior;
    private SqlUpsertSettings upsertSettings;

    @Override
    public String type() {
        return this.type;
    }

    public Object sqlWriterStoredProcedureName() {
        return this.sqlWriterStoredProcedureName;
    }

    public SqlServerSink withSqlWriterStoredProcedureName(Object sqlWriterStoredProcedureName) {
        this.sqlWriterStoredProcedureName = sqlWriterStoredProcedureName;
        return this;
    }

    public Object sqlWriterTableType() {
        return this.sqlWriterTableType;
    }

    public SqlServerSink withSqlWriterTableType(Object sqlWriterTableType) {
        this.sqlWriterTableType = sqlWriterTableType;
        return this;
    }

    public Object preCopyScript() {
        return this.preCopyScript;
    }

    public SqlServerSink withPreCopyScript(Object preCopyScript) {
        this.preCopyScript = preCopyScript;
        return this;
    }

    public Object storedProcedureParameters() {
        return this.storedProcedureParameters;
    }

    public SqlServerSink withStoredProcedureParameters(Object storedProcedureParameters) {
        this.storedProcedureParameters = storedProcedureParameters;
        return this;
    }

    public Object storedProcedureTableTypeParameterName() {
        return this.storedProcedureTableTypeParameterName;
    }

    public SqlServerSink withStoredProcedureTableTypeParameterName(Object storedProcedureTableTypeParameterName) {
        this.storedProcedureTableTypeParameterName = storedProcedureTableTypeParameterName;
        return this;
    }

    public Object tableOption() {
        return this.tableOption;
    }

    public SqlServerSink withTableOption(Object tableOption) {
        this.tableOption = tableOption;
        return this;
    }

    public Object sqlWriterUseTableLock() {
        return this.sqlWriterUseTableLock;
    }

    public SqlServerSink withSqlWriterUseTableLock(Object sqlWriterUseTableLock) {
        this.sqlWriterUseTableLock = sqlWriterUseTableLock;
        return this;
    }

    public Object writeBehavior() {
        return this.writeBehavior;
    }

    public SqlServerSink withWriteBehavior(Object writeBehavior) {
        this.writeBehavior = writeBehavior;
        return this;
    }

    public SqlUpsertSettings upsertSettings() {
        return this.upsertSettings;
    }

    public SqlServerSink withUpsertSettings(SqlUpsertSettings upsertSettings) {
        this.upsertSettings = upsertSettings;
        return this;
    }

    @Override
    public SqlServerSink withWriteBatchSize(Object writeBatchSize) {
        super.withWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public SqlServerSink withWriteBatchTimeout(Object writeBatchTimeout) {
        super.withWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public SqlServerSink withSinkRetryCount(Object sinkRetryCount) {
        super.withSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public SqlServerSink withSinkRetryWait(Object sinkRetryWait) {
        super.withSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public SqlServerSink withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public SqlServerSink withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.upsertSettings() != null) {
            this.upsertSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("writeBatchSize", this.writeBatchSize());
        jsonWriter.writeUntypedField("writeBatchTimeout", this.writeBatchTimeout());
        jsonWriter.writeUntypedField("sinkRetryCount", this.sinkRetryCount());
        jsonWriter.writeUntypedField("sinkRetryWait", this.sinkRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("sqlWriterStoredProcedureName", this.sqlWriterStoredProcedureName);
        jsonWriter.writeUntypedField("sqlWriterTableType", this.sqlWriterTableType);
        jsonWriter.writeUntypedField("preCopyScript", this.preCopyScript);
        jsonWriter.writeUntypedField("storedProcedureParameters", this.storedProcedureParameters);
        jsonWriter.writeUntypedField("storedProcedureTableTypeParameterName", this.storedProcedureTableTypeParameterName);
        jsonWriter.writeUntypedField("tableOption", this.tableOption);
        jsonWriter.writeUntypedField("sqlWriterUseTableLock", this.sqlWriterUseTableLock);
        jsonWriter.writeUntypedField("writeBehavior", this.writeBehavior);
        jsonWriter.writeJsonField("upsertSettings", (JsonSerializable)this.upsertSettings);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SqlServerSink fromJson(JsonReader jsonReader) throws IOException {
        return (SqlServerSink)jsonReader.readObject(reader -> {
            SqlServerSink deserializedSqlServerSink = new SqlServerSink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedSqlServerSink.withWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedSqlServerSink.withWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedSqlServerSink.withSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedSqlServerSink.withSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSqlServerSink.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedSqlServerSink.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSqlServerSink.type = reader.getString();
                    continue;
                }
                if ("sqlWriterStoredProcedureName".equals(fieldName)) {
                    deserializedSqlServerSink.sqlWriterStoredProcedureName = reader.readUntyped();
                    continue;
                }
                if ("sqlWriterTableType".equals(fieldName)) {
                    deserializedSqlServerSink.sqlWriterTableType = reader.readUntyped();
                    continue;
                }
                if ("preCopyScript".equals(fieldName)) {
                    deserializedSqlServerSink.preCopyScript = reader.readUntyped();
                    continue;
                }
                if ("storedProcedureParameters".equals(fieldName)) {
                    deserializedSqlServerSink.storedProcedureParameters = reader.readUntyped();
                    continue;
                }
                if ("storedProcedureTableTypeParameterName".equals(fieldName)) {
                    deserializedSqlServerSink.storedProcedureTableTypeParameterName = reader.readUntyped();
                    continue;
                }
                if ("tableOption".equals(fieldName)) {
                    deserializedSqlServerSink.tableOption = reader.readUntyped();
                    continue;
                }
                if ("sqlWriterUseTableLock".equals(fieldName)) {
                    deserializedSqlServerSink.sqlWriterUseTableLock = reader.readUntyped();
                    continue;
                }
                if ("writeBehavior".equals(fieldName)) {
                    deserializedSqlServerSink.writeBehavior = reader.readUntyped();
                    continue;
                }
                if ("upsertSettings".equals(fieldName)) {
                    deserializedSqlServerSink.upsertSettings = SqlUpsertSettings.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSqlServerSink.withAdditionalProperties(additionalProperties);
            return deserializedSqlServerSink;
        });
    }
}

