/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.SqlAlwaysEncryptedAkvAuthType;
import java.io.IOException;

public final class SqlAlwaysEncryptedProperties
implements JsonSerializable<SqlAlwaysEncryptedProperties> {
    private SqlAlwaysEncryptedAkvAuthType alwaysEncryptedAkvAuthType;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private CredentialReference credential;
    private static final ClientLogger LOGGER = new ClientLogger(SqlAlwaysEncryptedProperties.class);

    public SqlAlwaysEncryptedAkvAuthType alwaysEncryptedAkvAuthType() {
        return this.alwaysEncryptedAkvAuthType;
    }

    public SqlAlwaysEncryptedProperties withAlwaysEncryptedAkvAuthType(SqlAlwaysEncryptedAkvAuthType alwaysEncryptedAkvAuthType) {
        this.alwaysEncryptedAkvAuthType = alwaysEncryptedAkvAuthType;
        return this;
    }

    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    public SqlAlwaysEncryptedProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public SqlAlwaysEncryptedProperties withServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public SqlAlwaysEncryptedProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public void validate() {
        if (this.alwaysEncryptedAkvAuthType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property alwaysEncryptedAkvAuthType in model SqlAlwaysEncryptedProperties"));
        }
        if (this.servicePrincipalKey() != null) {
            this.servicePrincipalKey().validate();
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("alwaysEncryptedAkvAuthType", this.alwaysEncryptedAkvAuthType == null ? null : this.alwaysEncryptedAkvAuthType.toString());
        jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        return jsonWriter.writeEndObject();
    }

    public static SqlAlwaysEncryptedProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SqlAlwaysEncryptedProperties)jsonReader.readObject(reader -> {
            SqlAlwaysEncryptedProperties deserializedSqlAlwaysEncryptedProperties = new SqlAlwaysEncryptedProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("alwaysEncryptedAkvAuthType".equals(fieldName)) {
                    deserializedSqlAlwaysEncryptedProperties.alwaysEncryptedAkvAuthType = SqlAlwaysEncryptedAkvAuthType.fromString(reader.getString());
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedSqlAlwaysEncryptedProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalKey".equals(fieldName)) {
                    deserializedSqlAlwaysEncryptedProperties.servicePrincipalKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedSqlAlwaysEncryptedProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlAlwaysEncryptedProperties;
        });
    }
}

