/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySource;
import com.azure.resourcemanager.datafactory.models.SnowflakeExportCopyCommand;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SnowflakeV2Source
extends CopySource {
    private String type = "SnowflakeV2Source";
    private Object query;
    private SnowflakeExportCopyCommand exportSettings;
    private static final ClientLogger LOGGER = new ClientLogger(SnowflakeV2Source.class);

    @Override
    public String type() {
        return this.type;
    }

    public Object query() {
        return this.query;
    }

    public SnowflakeV2Source withQuery(Object query) {
        this.query = query;
        return this;
    }

    public SnowflakeExportCopyCommand exportSettings() {
        return this.exportSettings;
    }

    public SnowflakeV2Source withExportSettings(SnowflakeExportCopyCommand exportSettings) {
        this.exportSettings = exportSettings;
        return this;
    }

    @Override
    public SnowflakeV2Source withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public SnowflakeV2Source withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public SnowflakeV2Source withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public SnowflakeV2Source withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.exportSettings() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property exportSettings in model SnowflakeV2Source"));
        }
        this.exportSettings().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeJsonField("exportSettings", (JsonSerializable)this.exportSettings);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("query", this.query);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SnowflakeV2Source fromJson(JsonReader jsonReader) throws IOException {
        return (SnowflakeV2Source)jsonReader.readObject(reader -> {
            SnowflakeV2Source deserializedSnowflakeV2Source = new SnowflakeV2Source();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedSnowflakeV2Source.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedSnowflakeV2Source.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSnowflakeV2Source.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedSnowflakeV2Source.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("exportSettings".equals(fieldName)) {
                    deserializedSnowflakeV2Source.exportSettings = SnowflakeExportCopyCommand.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSnowflakeV2Source.type = reader.getString();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedSnowflakeV2Source.query = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSnowflakeV2Source.withAdditionalProperties(additionalProperties);
            return deserializedSnowflakeV2Source;
        });
    }
}

