/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.SnowflakeLinkedV2ServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.SnowflakeAuthenticationType;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SnowflakeV2LinkedService
extends LinkedService {
    private String type = "SnowflakeV2";
    private SnowflakeLinkedV2ServiceTypeProperties innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SnowflakeV2LinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    SnowflakeLinkedV2ServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public SnowflakeV2LinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public SnowflakeV2LinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public SnowflakeV2LinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public SnowflakeV2LinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public SnowflakeV2LinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object accountIdentifier() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().accountIdentifier();
    }

    public SnowflakeV2LinkedService withAccountIdentifier(Object accountIdentifier) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withAccountIdentifier(accountIdentifier);
        return this;
    }

    public Object user() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().user();
    }

    public SnowflakeV2LinkedService withUser(Object user) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withUser(user);
        return this;
    }

    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    public SnowflakeV2LinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    public Object database() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().database();
    }

    public SnowflakeV2LinkedService withDatabase(Object database) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withDatabase(database);
        return this;
    }

    public Object warehouse() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().warehouse();
    }

    public SnowflakeV2LinkedService withWarehouse(Object warehouse) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withWarehouse(warehouse);
        return this;
    }

    public SnowflakeAuthenticationType authenticationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authenticationType();
    }

    public SnowflakeV2LinkedService withAuthenticationType(SnowflakeAuthenticationType authenticationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthenticationType(authenticationType);
        return this;
    }

    public Object clientId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clientId();
    }

    public SnowflakeV2LinkedService withClientId(Object clientId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withClientId(clientId);
        return this;
    }

    public SecretBase clientSecret() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clientSecret();
    }

    public SnowflakeV2LinkedService withClientSecret(SecretBase clientSecret) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withClientSecret(clientSecret);
        return this;
    }

    public Object tenantId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().tenantId();
    }

    public SnowflakeV2LinkedService withTenantId(Object tenantId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withTenantId(tenantId);
        return this;
    }

    public Object scope() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().scope();
    }

    public SnowflakeV2LinkedService withScope(Object scope) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withScope(scope);
        return this;
    }

    public SecretBase privateKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().privateKey();
    }

    public SnowflakeV2LinkedService withPrivateKey(SecretBase privateKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withPrivateKey(privateKey);
        return this;
    }

    public SecretBase privateKeyPassphrase() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().privateKeyPassphrase();
    }

    public SnowflakeV2LinkedService withPrivateKeyPassphrase(SecretBase privateKeyPassphrase) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withPrivateKeyPassphrase(privateKeyPassphrase);
        return this;
    }

    public Object role() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().role();
    }

    public SnowflakeV2LinkedService withRole(Object role) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withRole(role);
        return this;
    }

    public Object host() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().host();
    }

    public SnowflakeV2LinkedService withHost(Object host) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withHost(host);
        return this;
    }

    public Object schema() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().schema();
    }

    public SnowflakeV2LinkedService withSchema(Object schema) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withSchema(schema);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public SnowflakeV2LinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model SnowflakeV2LinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SnowflakeV2LinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (SnowflakeV2LinkedService)jsonReader.readObject(reader -> {
            SnowflakeV2LinkedService deserializedSnowflakeV2LinkedService = new SnowflakeV2LinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedSnowflakeV2LinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedSnowflakeV2LinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSnowflakeV2LinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSnowflakeV2LinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSnowflakeV2LinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedSnowflakeV2LinkedService.innerTypeProperties = SnowflakeLinkedV2ServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSnowflakeV2LinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSnowflakeV2LinkedService.withAdditionalProperties(additionalProperties);
            return deserializedSnowflakeV2LinkedService;
        });
    }
}

