/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.ExportSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SnowflakeExportCopyCommand
extends ExportSettings {
    private String type = "SnowflakeExportCopyCommand";
    private Map<String, Object> additionalCopyOptions;
    private Map<String, Object> additionalFormatOptions;
    private Object storageIntegration;

    @Override
    public String type() {
        return this.type;
    }

    public Map<String, Object> additionalCopyOptions() {
        return this.additionalCopyOptions;
    }

    public SnowflakeExportCopyCommand withAdditionalCopyOptions(Map<String, Object> additionalCopyOptions) {
        this.additionalCopyOptions = additionalCopyOptions;
        return this;
    }

    public Map<String, Object> additionalFormatOptions() {
        return this.additionalFormatOptions;
    }

    public SnowflakeExportCopyCommand withAdditionalFormatOptions(Map<String, Object> additionalFormatOptions) {
        this.additionalFormatOptions = additionalFormatOptions;
        return this;
    }

    public Object storageIntegration() {
        return this.storageIntegration;
    }

    public SnowflakeExportCopyCommand withStorageIntegration(Object storageIntegration) {
        this.storageIntegration = storageIntegration;
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeMapField("additionalCopyOptions", this.additionalCopyOptions, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeMapField("additionalFormatOptions", this.additionalFormatOptions, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeUntypedField("storageIntegration", this.storageIntegration);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SnowflakeExportCopyCommand fromJson(JsonReader jsonReader) throws IOException {
        return (SnowflakeExportCopyCommand)jsonReader.readObject(reader -> {
            SnowflakeExportCopyCommand deserializedSnowflakeExportCopyCommand = new SnowflakeExportCopyCommand();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedSnowflakeExportCopyCommand.type = reader.getString();
                    continue;
                }
                if ("additionalCopyOptions".equals(fieldName)) {
                    Map additionalCopyOptions;
                    deserializedSnowflakeExportCopyCommand.additionalCopyOptions = additionalCopyOptions = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("additionalFormatOptions".equals(fieldName)) {
                    Map additionalFormatOptions;
                    deserializedSnowflakeExportCopyCommand.additionalFormatOptions = additionalFormatOptions = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("storageIntegration".equals(fieldName)) {
                    deserializedSnowflakeExportCopyCommand.storageIntegration = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSnowflakeExportCopyCommand.withAdditionalProperties(additionalProperties);
            return deserializedSnowflakeExportCopyCommand;
        });
    }
}

