/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.SetVariableActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.ControlActivity;
import com.azure.resourcemanager.datafactory.models.SecureInputOutputPolicy;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SetVariableActivity
extends ControlActivity {
    private String type = "SetVariable";
    private SetVariableActivityTypeProperties innerTypeProperties = new SetVariableActivityTypeProperties();
    private SecureInputOutputPolicy policy;
    private static final ClientLogger LOGGER = new ClientLogger(SetVariableActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    SetVariableActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    public SecureInputOutputPolicy policy() {
        return this.policy;
    }

    public SetVariableActivity withPolicy(SecureInputOutputPolicy policy) {
        this.policy = policy;
        return this;
    }

    @Override
    public SetVariableActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public SetVariableActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public SetVariableActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public SetVariableActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public SetVariableActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public SetVariableActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public String variableName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().variableName();
    }

    public SetVariableActivity withVariableName(String variableName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SetVariableActivityTypeProperties();
        }
        this.innerTypeProperties().withVariableName(variableName);
        return this;
    }

    public Object value() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().value();
    }

    public SetVariableActivity withValue(Object value) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SetVariableActivityTypeProperties();
        }
        this.innerTypeProperties().withValue(value);
        return this;
    }

    public Boolean setSystemVariable() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().setSystemVariable();
    }

    public SetVariableActivity withSetSystemVariable(Boolean setSystemVariable) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SetVariableActivityTypeProperties();
        }
        this.innerTypeProperties().withSetSystemVariable(setSystemVariable);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model SetVariableActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.policy() != null) {
            this.policy().validate();
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model SetVariableActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SetVariableActivity fromJson(JsonReader jsonReader) throws IOException {
        return (SetVariableActivity)jsonReader.readObject(reader -> {
            SetVariableActivity deserializedSetVariableActivity = new SetVariableActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSetVariableActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSetVariableActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSetVariableActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedSetVariableActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedSetVariableActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedSetVariableActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedSetVariableActivity.innerTypeProperties = SetVariableActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSetVariableActivity.type = reader.getString();
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedSetVariableActivity.policy = SecureInputOutputPolicy.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSetVariableActivity.withAdditionalProperties(additionalProperties);
            return deserializedSetVariableActivity;
        });
    }
}

