/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.SelfHostedIntegrationRuntimeTypeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntime;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeType;
import com.azure.resourcemanager.datafactory.models.LinkedIntegrationRuntimeType;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SelfHostedIntegrationRuntime
extends IntegrationRuntime {
    private IntegrationRuntimeType type = IntegrationRuntimeType.SELF_HOSTED;
    private SelfHostedIntegrationRuntimeTypeProperties innerTypeProperties;

    @Override
    public IntegrationRuntimeType type() {
        return this.type;
    }

    SelfHostedIntegrationRuntimeTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public SelfHostedIntegrationRuntime withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    public LinkedIntegrationRuntimeType linkedInfo() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().linkedInfo();
    }

    public SelfHostedIntegrationRuntime withLinkedInfo(LinkedIntegrationRuntimeType linkedInfo) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SelfHostedIntegrationRuntimeTypeProperties();
        }
        this.innerTypeProperties().withLinkedInfo(linkedInfo);
        return this;
    }

    public Boolean selfContainedInteractiveAuthoringEnabled() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().selfContainedInteractiveAuthoringEnabled();
    }

    public SelfHostedIntegrationRuntime withSelfContainedInteractiveAuthoringEnabled(Boolean selfContainedInteractiveAuthoringEnabled) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SelfHostedIntegrationRuntimeTypeProperties();
        }
        this.innerTypeProperties().withSelfContainedInteractiveAuthoringEnabled(selfContainedInteractiveAuthoringEnabled);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() != null) {
            this.innerTypeProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SelfHostedIntegrationRuntime fromJson(JsonReader jsonReader) throws IOException {
        return (SelfHostedIntegrationRuntime)jsonReader.readObject(reader -> {
            SelfHostedIntegrationRuntime deserializedSelfHostedIntegrationRuntime = new SelfHostedIntegrationRuntime();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntime.withDescription(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntime.type = IntegrationRuntimeType.fromString(reader.getString());
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntime.innerTypeProperties = SelfHostedIntegrationRuntimeTypeProperties.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSelfHostedIntegrationRuntime.withAdditionalProperties(additionalProperties);
            return deserializedSelfHostedIntegrationRuntime;
        });
    }
}

