/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.LogLocationSettings;
import com.azure.resourcemanager.datafactory.models.ScriptActivityLogDestination;
import java.io.IOException;

public final class ScriptActivityTypePropertiesLogSettings
implements JsonSerializable<ScriptActivityTypePropertiesLogSettings> {
    private ScriptActivityLogDestination logDestination;
    private LogLocationSettings logLocationSettings;
    private static final ClientLogger LOGGER = new ClientLogger(ScriptActivityTypePropertiesLogSettings.class);

    public ScriptActivityLogDestination logDestination() {
        return this.logDestination;
    }

    public ScriptActivityTypePropertiesLogSettings withLogDestination(ScriptActivityLogDestination logDestination) {
        this.logDestination = logDestination;
        return this;
    }

    public LogLocationSettings logLocationSettings() {
        return this.logLocationSettings;
    }

    public ScriptActivityTypePropertiesLogSettings withLogLocationSettings(LogLocationSettings logLocationSettings) {
        this.logLocationSettings = logLocationSettings;
        return this;
    }

    public void validate() {
        if (this.logDestination() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property logDestination in model ScriptActivityTypePropertiesLogSettings"));
        }
        if (this.logLocationSettings() != null) {
            this.logLocationSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("logDestination", this.logDestination == null ? null : this.logDestination.toString());
        jsonWriter.writeJsonField("logLocationSettings", (JsonSerializable)this.logLocationSettings);
        return jsonWriter.writeEndObject();
    }

    public static ScriptActivityTypePropertiesLogSettings fromJson(JsonReader jsonReader) throws IOException {
        return (ScriptActivityTypePropertiesLogSettings)jsonReader.readObject(reader -> {
            ScriptActivityTypePropertiesLogSettings deserializedScriptActivityTypePropertiesLogSettings = new ScriptActivityTypePropertiesLogSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("logDestination".equals(fieldName)) {
                    deserializedScriptActivityTypePropertiesLogSettings.logDestination = ScriptActivityLogDestination.fromString(reader.getString());
                    continue;
                }
                if ("logLocationSettings".equals(fieldName)) {
                    deserializedScriptActivityTypePropertiesLogSettings.logLocationSettings = LogLocationSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScriptActivityTypePropertiesLogSettings;
        });
    }
}

