/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.SapOpenHubLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SapOpenHubLinkedService
extends LinkedService {
    private String type = "SapOpenHub";
    private SapOpenHubLinkedServiceTypeProperties innerTypeProperties = new SapOpenHubLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SapOpenHubLinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    SapOpenHubLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public SapOpenHubLinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public SapOpenHubLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public SapOpenHubLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public SapOpenHubLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public SapOpenHubLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object server() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().server();
    }

    public SapOpenHubLinkedService withServer(Object server) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOpenHubLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServer(server);
        return this;
    }

    public Object systemNumber() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().systemNumber();
    }

    public SapOpenHubLinkedService withSystemNumber(Object systemNumber) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOpenHubLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSystemNumber(systemNumber);
        return this;
    }

    public Object clientId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clientId();
    }

    public SapOpenHubLinkedService withClientId(Object clientId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOpenHubLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withClientId(clientId);
        return this;
    }

    public Object language() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().language();
    }

    public SapOpenHubLinkedService withLanguage(Object language) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOpenHubLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withLanguage(language);
        return this;
    }

    public Object systemId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().systemId();
    }

    public SapOpenHubLinkedService withSystemId(Object systemId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOpenHubLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSystemId(systemId);
        return this;
    }

    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    public SapOpenHubLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOpenHubLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    public SapOpenHubLinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOpenHubLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    public Object messageServer() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().messageServer();
    }

    public SapOpenHubLinkedService withMessageServer(Object messageServer) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOpenHubLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMessageServer(messageServer);
        return this;
    }

    public Object messageServerService() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().messageServerService();
    }

    public SapOpenHubLinkedService withMessageServerService(Object messageServerService) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOpenHubLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMessageServerService(messageServerService);
        return this;
    }

    public Object logonGroup() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().logonGroup();
    }

    public SapOpenHubLinkedService withLogonGroup(Object logonGroup) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOpenHubLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withLogonGroup(logonGroup);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public SapOpenHubLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOpenHubLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model SapOpenHubLinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SapOpenHubLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (SapOpenHubLinkedService)jsonReader.readObject(reader -> {
            SapOpenHubLinkedService deserializedSapOpenHubLinkedService = new SapOpenHubLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedSapOpenHubLinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedSapOpenHubLinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSapOpenHubLinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSapOpenHubLinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSapOpenHubLinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedSapOpenHubLinkedService.innerTypeProperties = SapOpenHubLinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSapOpenHubLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSapOpenHubLinkedService.withAdditionalProperties(additionalProperties);
            return deserializedSapOpenHubLinkedService;
        });
    }
}

