/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.SapOdpResourceDatasetTypeProperties;
import com.azure.resourcemanager.datafactory.models.Dataset;
import com.azure.resourcemanager.datafactory.models.DatasetFolder;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SapOdpResourceDataset
extends Dataset {
    private String type = "SapOdpResource";
    private SapOdpResourceDatasetTypeProperties innerTypeProperties = new SapOdpResourceDatasetTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SapOdpResourceDataset.class);

    @Override
    public String type() {
        return this.type;
    }

    SapOdpResourceDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public SapOdpResourceDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public SapOdpResourceDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    @Override
    public SapOdpResourceDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public SapOdpResourceDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public SapOdpResourceDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public SapOdpResourceDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public SapOdpResourceDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    public Object context() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().context();
    }

    public SapOdpResourceDataset withContext(Object context) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpResourceDatasetTypeProperties();
        }
        this.innerTypeProperties().withContext(context);
        return this;
    }

    public Object objectName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().objectName();
    }

    public SapOdpResourceDataset withObjectName(Object objectName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpResourceDatasetTypeProperties();
        }
        this.innerTypeProperties().withObjectName(objectName);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model SapOdpResourceDataset"));
        }
        this.innerTypeProperties().validate();
        if (this.linkedServiceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedServiceName in model SapOdpResourceDataset"));
        }
        this.linkedServiceName().validate();
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.folder() != null) {
            this.folder().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeUntypedField("structure", this.structure());
        jsonWriter.writeUntypedField("schema", this.schema());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SapOdpResourceDataset fromJson(JsonReader jsonReader) throws IOException {
        return (SapOdpResourceDataset)jsonReader.readObject(reader -> {
            SapOdpResourceDataset deserializedSapOdpResourceDataset = new SapOdpResourceDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedSapOdpResourceDataset.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSapOdpResourceDataset.withDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedSapOdpResourceDataset.withStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedSapOdpResourceDataset.withSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSapOdpResourceDataset.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSapOdpResourceDataset.withAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedSapOdpResourceDataset.withFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedSapOdpResourceDataset.innerTypeProperties = SapOdpResourceDatasetTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSapOdpResourceDataset.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSapOdpResourceDataset.withAdditionalProperties(additionalProperties);
            return deserializedSapOdpResourceDataset;
        });
    }
}

