/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DataFlowReference;
import com.azure.resourcemanager.datafactory.models.DataFlowSink;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import java.io.IOException;

public final class PowerQuerySink
extends DataFlowSink {
    private String script;
    private static final ClientLogger LOGGER = new ClientLogger(PowerQuerySink.class);

    public String script() {
        return this.script;
    }

    public PowerQuerySink withScript(String script) {
        this.script = script;
        return this;
    }

    @Override
    public PowerQuerySink withSchemaLinkedService(LinkedServiceReference schemaLinkedService) {
        super.withSchemaLinkedService(schemaLinkedService);
        return this;
    }

    @Override
    public PowerQuerySink withRejectedDataLinkedService(LinkedServiceReference rejectedDataLinkedService) {
        super.withRejectedDataLinkedService(rejectedDataLinkedService);
        return this;
    }

    @Override
    public PowerQuerySink withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public PowerQuerySink withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public PowerQuerySink withDataset(DatasetReference dataset) {
        super.withDataset(dataset);
        return this;
    }

    @Override
    public PowerQuerySink withLinkedService(LinkedServiceReference linkedService) {
        super.withLinkedService(linkedService);
        return this;
    }

    @Override
    public PowerQuerySink withFlowlet(DataFlowReference flowlet) {
        super.withFlowlet(flowlet);
        return this;
    }

    @Override
    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model PowerQuerySink"));
        }
        if (this.dataset() != null) {
            this.dataset().validate();
        }
        if (this.linkedService() != null) {
            this.linkedService().validate();
        }
        if (this.flowlet() != null) {
            this.flowlet().validate();
        }
        if (this.schemaLinkedService() != null) {
            this.schemaLinkedService().validate();
        }
        if (this.rejectedDataLinkedService() != null) {
            this.rejectedDataLinkedService().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeJsonField("dataset", (JsonSerializable)this.dataset());
        jsonWriter.writeJsonField("linkedService", (JsonSerializable)this.linkedService());
        jsonWriter.writeJsonField("flowlet", (JsonSerializable)this.flowlet());
        jsonWriter.writeJsonField("schemaLinkedService", (JsonSerializable)this.schemaLinkedService());
        jsonWriter.writeJsonField("rejectedDataLinkedService", (JsonSerializable)this.rejectedDataLinkedService());
        jsonWriter.writeStringField("script", this.script);
        return jsonWriter.writeEndObject();
    }

    public static PowerQuerySink fromJson(JsonReader jsonReader) throws IOException {
        return (PowerQuerySink)jsonReader.readObject(reader -> {
            PowerQuerySink deserializedPowerQuerySink = new PowerQuerySink();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedPowerQuerySink.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedPowerQuerySink.withDescription(reader.getString());
                    continue;
                }
                if ("dataset".equals(fieldName)) {
                    deserializedPowerQuerySink.withDataset(DatasetReference.fromJson(reader));
                    continue;
                }
                if ("linkedService".equals(fieldName)) {
                    deserializedPowerQuerySink.withLinkedService(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("flowlet".equals(fieldName)) {
                    deserializedPowerQuerySink.withFlowlet(DataFlowReference.fromJson(reader));
                    continue;
                }
                if ("schemaLinkedService".equals(fieldName)) {
                    deserializedPowerQuerySink.withSchemaLinkedService(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("rejectedDataLinkedService".equals(fieldName)) {
                    deserializedPowerQuerySink.withRejectedDataLinkedService(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("script".equals(fieldName)) {
                    deserializedPowerQuerySink.script = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPowerQuerySink;
        });
    }
}

